/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.WholeGroupPool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MultiResourceGroupAssignment
implements AssignmentRestriction {
    private final Set<IResourceGroup> resourceGroups;
    private final Set<String> selectedResourceGroupIds;
    private final Set<String> availableResourceIds;

    public MultiResourceGroupAssignment(Set<IResourceGroup> resourceGroups) {
        this.resourceGroups = Collections.unmodifiableSet(resourceGroups);
        this.selectedResourceGroupIds = Collections.unmodifiableSet(RmIdentifiableUtils.getIds(resourceGroups));
        this.availableResourceIds = MultiResourceGroupAssignment.getResourceIds(resourceGroups);
    }

    private static Set<String> getResourceIds(Set<IResourceGroup> resourceGroups) {
        HashSet ids = Sets.newHashSet();
        for (IResourceGroup group : resourceGroups) {
            ids.addAll(RmIdentifiableUtils.getIds(group.getResources()));
        }
        return ids;
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        HashSet pools = Sets.newHashSet();
        for (IMutableResourceGroup mutableGroup : mutableResourceGroups) {
            if (!this.selectedResourceGroupIds.contains(mutableGroup.getId())) continue;
            WholeGroupPool pool = new WholeGroupPool(mutableGroup);
            pools.add(pool);
        }
        return pools;
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        HashSet pools = Sets.newHashSet();
        for (IResourceGroup group : this.resourceGroups) {
            ResourcePool pool = new ResourcePool(group);
            pools.add(pool);
        }
        return pools;
    }

    @Override
    public Optional<Integer> getWorkSlotIndex() {
        return Optional.absent();
    }

    @Override
    public Set<String> getStageTaskIds() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getResourceGroupIds() {
        return RmIdentifiableUtils.getIds(this.resourceGroups);
    }

    @Override
    public Optional<AssignmentRestriction> getStageTaskResourceRestriction(String stageTaskId) {
        return Optional.absent();
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        return RmIdentifiableUtils.getElementsWithIds(this.availableResourceIds, skillRelevantResources);
    }

    @Override
    public Set<IWorkResource> getResources() {
        HashSet allResources = Sets.newHashSet();
        for (IResourceGroup group : this.resourceGroups) {
            allResources.addAll(group.getResources());
        }
        return allResources;
    }

    public String toString() {
        return "MultiResourceGroupAssignment{selectedResourceGroupIds=" + Joiner.on((String)",").join(this.selectedResourceGroupIds) + '}';
    }
}

