/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningRelationsDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemQueryRowData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jgrapht.Graphs;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;

@Immutable
class StructuredQueryDataTree {
    private static final Log LOGGER = Log.with(StructuredQueryDataTree.class);
    private final DirectedAcyclicGraph<String, DefaultEdge> relationForest;
    private final Map<String, Set<EstimationDataBlock>> estimations;
    private final Map<String, ReplanningRelationsDataBlock> replanningRelations;
    private final List<WorkItemDataBlock> workItemData;
    private final Map<String, Integer> indexMap;

    StructuredQueryDataTree(DirectedAcyclicGraph<String, DefaultEdge> relationForest, Map<String, Set<EstimationDataBlock>> estimations, Map<String, ReplanningRelationsDataBlock> replanningRelations, List<WorkItemDataBlock> workItemData, Map<String, Integer> indexMap) {
        this.relationForest = relationForest;
        this.estimations = estimations;
        this.replanningRelations = replanningRelations;
        this.workItemData = workItemData;
        this.indexMap = indexMap;
    }

    Optional<String> getParent(String itemId) {
        List<String> predecessors = Graphs.predecessorListOf(this.relationForest, itemId);
        if (predecessors.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)predecessors.get(0));
    }

    List<String> getChildren(String parentId) {
        List<String> successorIds = Graphs.successorListOf(this.relationForest, parentId);
        Collections.sort(successorIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Ints.compare((int)((Integer)StructuredQueryDataTree.this.indexMap.get(o1)), (int)((Integer)StructuredQueryDataTree.this.indexMap.get(o2)));
            }
        });
        return successorIds;
    }

    List<WorkItemDataBlock> getData() {
        return this.workItemData;
    }

    Set<EstimationDataBlock> getAssociatedEstimates(String id) {
        Set<EstimationDataBlock> estimationBlocks = this.estimations.get(id);
        if (estimationBlocks != null) {
            return estimationBlocks;
        }
        return Sets.newHashSet();
    }

    Optional<ReplanningRelationsDataBlock> getAssociatedReplanningRelationData(String id) {
        return Optional.fromNullable((Object)this.replanningRelations.get(id));
    }

    static StructuredQueryDataTree createInstance(List<WorkItemQueryRowData> rowData) {
        Preconditions.checkNotNull(rowData, (Object)"row data must not be null");
        LOGGER.debug("initialize for row data: %s", Joiner.on((String)",").join(rowData));
        DirectedAcyclicGraph<String, DefaultEdge> relations = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        ArrayList workItemData = Lists.newArrayList();
        HashMap estimations = Maps.newHashMap();
        HashMap replanningRelations = Maps.newHashMap();
        HashMap indexMap = Maps.newHashMap();
        int index = 0;
        for (WorkItemQueryRowData row : rowData) {
            Optional<ReplanningRelationsDataBlock> replanningRelationData;
            List<WorkItemDataBlock> workItemBlocks = row.getWorkItemData();
            for (int i = 0; i < workItemBlocks.size(); ++i) {
                WorkItemDataBlock itemBlock = workItemBlocks.get(i);
                String id = itemBlock.getId();
                if (relations.vertexSet().contains(id)) continue;
                relations.addVertex(id);
                workItemData.add(itemBlock);
                if (i > 0) {
                    String parentId = workItemBlocks.get(i - 1).getId();
                    relations.addEdge(parentId, id);
                }
                indexMap.put(id, index++);
            }
            String lastItemId = workItemBlocks.get(workItemBlocks.size() - 1).getId();
            Optional<EstimationDataBlock> estimationData = row.getEstimationData();
            if (estimationData.isPresent()) {
                if (!estimations.containsKey(lastItemId)) {
                    estimations.put(lastItemId, Sets.newHashSet((Object[])new EstimationDataBlock[]{(EstimationDataBlock)row.getEstimationData().get()}));
                } else {
                    ((Set)estimations.get(lastItemId)).add(row.getEstimationData().get());
                }
            }
            if (!(replanningRelationData = row.getReplanningRelationData()).isPresent()) continue;
            replanningRelations.put(lastItemId, replanningRelationData.get());
        }
        StructuredQueryDataTree instance = new StructuredQueryDataTree(relations, estimations, replanningRelations, workItemData, indexMap);
        LOGGER.debug("created instance: %s", instance);
        return instance;
    }
}

