/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.theme;

import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.theme.ThemeOperationFactory;
import javax.ws.rs.core.Response;

public interface WorkItemThemeServiceHandler {
    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setTheme(EntityContext<IWorkItem> var1, String var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setThemeInBulk(BulkEntityContext<IWorkItem> var1, String var2) throws Exception;

    public static class Impl
    implements WorkItemThemeServiceHandler {
        private final ThemeOperationFactory operationFactory;
        private final OperationExecutor operationExecutor;

        public Impl(OperationExecutor operationExecutor, PortfolioWorkItemPersistence workItemPersistence, PortfolioThemePersistence themePersistence) {
            this.operationExecutor = operationExecutor;
            this.operationFactory = new ThemeOperationFactory(workItemPersistence, themePersistence);
        }

        @Override
        public Response setTheme(EntityContext<IWorkItem> entityContext, String themeId) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(themeId));
        }

        @Override
        public Response setThemeInBulk(BulkEntityContext<IWorkItem> entityContext, String themeId) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(themeId));
        }
    }
}

