/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.release;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import java.net.URI;

class JiraReleaseExtensionLinkData
implements ReleaseExtensionLinkData {
    private final Long projectId;
    private final String projectKey;
    private final String projectName;
    private final String projectAvatar;
    private final String versionName;
    private final String versionDescription;
    private final String link;

    private JiraReleaseExtensionLinkData(String link, Long projectId, String projectKey, String projectName, String projectAvatar, String versionName, String versionDescription) {
        this.link = link;
        this.projectId = projectId;
        this.projectKey = projectKey;
        this.projectName = projectName;
        this.projectAvatar = projectAvatar;
        this.versionName = versionName;
        this.versionDescription = versionDescription;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getProjectAvatar() {
        return this.projectAvatar;
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public String getVersionDescription() {
        return this.versionDescription;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    static JiraReleaseExtensionLinkData createInstance(String link, Version jiraVersion, Project jiraProject, AvatarService avatarService) {
        String projectKey = null;
        Long projectId = null;
        String projectName = null;
        String avatarUrl = null;
        if (jiraProject != null) {
            projectId = jiraProject.getId();
            projectKey = jiraProject.getKey();
            projectName = jiraProject.getName();
            URI uri = avatarService.getProjectAvatarURL(jiraProject, Avatar.Size.SMALL);
            if (uri != null) {
                avatarUrl = uri.toString();
            }
        }
        return new JiraReleaseExtensionLinkData(link, projectId, projectKey, projectName, avatarUrl, jiraVersion.getName(), jiraVersion.getDescription());
    }
}

