/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.service;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalCustomFieldServiceImpl
implements GlobalCustomFieldService {
    private final Logger logger = LoggerFactory.getLogger(GlobalCustomFieldServiceImpl.class);
    @Autowired
    private GlobalPropertyDao globalPropertyDao;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private OfBizDelegator ofBizDelegator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomField getGlobalCustomField(CustomFieldMetadata fieldMetadata) throws CustomFieldException {
        this.logger.info("Retrieve or create custom field {}", (Object)fieldMetadata);
        try {
            CustomField field = this.getDefaultFieldOrNull(fieldMetadata);
            if (field == null) {
                GlobalCustomFieldServiceImpl globalCustomFieldServiceImpl = this;
                synchronized (globalCustomFieldServiceImpl) {
                    field = this.getDefaultFieldOrNull(fieldMetadata);
                    if (field == null) {
                        field = this.createGlobalCustomField(fieldMetadata);
                    }
                }
            }
            return field;
        }
        catch (Exception e) {
            this.logger.error("Failed to get or create custom field", (Throwable)e);
            throw new CustomFieldException(e);
        }
    }

    private CustomField getDefaultFieldOrNull(CustomFieldMetadata fieldMetadata) {
        Long id = this.globalPropertyDao.getLongProperty(fieldMetadata.getFieldType());
        if (id != null) {
            CustomField field = this.customFieldService.getCustomField(id);
            if (field != null) {
                return field;
            }
            if (this.verifyCustomFieldExistsInDB(id)) {
                throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", fieldMetadata.getFieldName(), id));
            }
        }
        return null;
    }

    private CustomField createGlobalCustomField(CustomFieldMetadata fieldMetadata) throws CustomFieldException {
        CustomField field = this.customFieldService.createCustomField(fieldMetadata);
        this.globalPropertyDao.setLongProperty(fieldMetadata.getFieldType(), field.getIdAsLong());
        return field;
    }

    private boolean verifyCustomFieldExistsInDB(Long customFieldId) {
        GenericValue customField = this.ofBizDelegator.findById("CustomField", customFieldId);
        return customField != null;
    }
}

