/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.ConnectionPrimer;
import com.atlassian.rm.common.pkqdsl.legacy.ConnectionProvider;
import com.google.common.base.Function;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectionProvider.class);
    private final ConnectionPrimer connectionPrimer;

    protected AbstractConnectionProvider(ConnectionPrimer connectionPrimer) {
        this.connectionPrimer = connectionPrimer;
    }

    protected abstract Connection getConnectionImpl(boolean var1);

    protected Logger log() {
        return log;
    }

    @Override
    public Connection borrowConnection() {
        this.log().debug("Borrowing connection without auto-commit");
        return this.prime(this.getConnectionImpl(false));
    }

    @Override
    public Connection borrowAutoCommitConnection() {
        this.log().debug("Borrowing connection with auto-commit");
        return this.prime(this.getConnectionImpl(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withConnection(Function<Connection, T> callback) {
        Connection connection = this.borrowConnection();
        try {
            Object object = callback.apply((Object)connection);
            return (T)object;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void returnConnection(Connection connection) {
        if (connection != null) {
            try {
                this.log().debug("Returning borrowed connection");
                connection.close();
            }
            catch (SQLException e) {
                this.log().warn(String.format("Unexpected exception when returning borrowed connection %s ", e.getMessage()));
            }
        }
    }

    private Connection prime(Connection connection) {
        return this.connectionPrimer.prime(connection);
    }
}

