/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IEligibleWorkTimeLine;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import java.util.Map;

class EligibleWorkTimeLine
implements IEligibleWorkTimeLine {
    private final Map<IResourceGroup, Map<IResourceType, IBoundedDiscreteStepFunction>> eligibilityFunctions;
    private final int endTime;

    EligibleWorkTimeLine(Map<IResourceGroup, Map<IResourceType, IBoundedDiscreteStepFunction>> eligibilityFunctions, int endTime) {
        this.eligibilityFunctions = eligibilityFunctions;
        this.endTime = endTime;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getEligibleWorkForTimeAndResourceGroup(int timeStep, IResourceGroup resourceGroup) {
        MutablePositivePrimitivesMap<IResourceType> eligible = RmCollectionUtils.newMutablePositiveMap();
        if (this.eligibilityFunctions.containsKey(resourceGroup)) {
            Map<IResourceType, IBoundedDiscreteStepFunction> eligibleForGroup = this.eligibilityFunctions.get(resourceGroup);
            for (Map.Entry<IResourceType, IBoundedDiscreteStepFunction> functionEntry : eligibleForGroup.entrySet()) {
                Optional<Float> eligibleAmount = functionEntry.getValue().getAt(timeStep);
                if (!eligibleAmount.isPresent()) continue;
                eligible.add(functionEntry.getKey(), ((Float)eligibleAmount.get()).floatValue());
            }
        }
        return eligible;
    }

    @Override
    public int getEndTime() {
        return this.endTime;
    }
}

