/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultActivityAssignmentProblem
implements ActivityAssignmentProblem {
    private final float[] availabilities;
    private final float[] demands;
    private final List<ResourceSkillVariable> variables;
    private final Map<Integer, Map<Integer, Integer>> resourceToSkillToIndexMapping;

    private DefaultActivityAssignmentProblem(float[] availabilities, float[] demands, boolean[][] resourceToSkills) {
        this.availabilities = availabilities;
        this.demands = demands;
        this.variables = DefaultActivityAssignmentProblem.initVariables(availabilities, demands, resourceToSkills);
        this.resourceToSkillToIndexMapping = DefaultActivityAssignmentProblem.initMapping(this.variables);
    }

    private static List<ResourceSkillVariable> initVariables(float[] availabilities, float[] demands, boolean[][] resourceToSkills) {
        ArrayList variables = Lists.newArrayListWithCapacity((int)(availabilities.length * demands.length));
        for (int r = 0; r < availabilities.length; ++r) {
            for (int s = 0; s < demands.length; ++s) {
                if (availabilities[r] <= 0.0f || demands[s] <= 0.0f || !resourceToSkills[r][s]) continue;
                variables.add(new ResourceSkillVariable(r, s));
            }
        }
        Collections.sort(variables, ResourceSkillVariable.COMPARATOR);
        return variables;
    }

    static Builder builder(int r, int s) {
        return new Builder(r, s);
    }

    @Override
    public List<ResourceSkillVariable> getVariables() {
        return this.variables;
    }

    @Override
    public int getSkills() {
        return this.demands.length;
    }

    @Override
    public float getDemand(int skill) {
        return this.demands[skill];
    }

    @Override
    public float getAvailability(int resource) {
        return this.availabilities[resource];
    }

    @Override
    public float getUpperBound(int resource, int skill) {
        return Math.min(this.availabilities[resource], this.demands[skill]);
    }

    @Override
    public int getResources() {
        return this.availabilities.length;
    }

    @Override
    public int getVariableCount() {
        return this.variables.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("availabilities", (Object)this.availabilities).add("demands", (Object)this.demands).add("variables", this.variables).add("resourceToSkillToIndexMapping", this.resourceToSkillToIndexMapping).toString();
    }

    private static Map<Integer, Map<Integer, Integer>> initMapping(List<ResourceSkillVariable> variables) {
        HashMap resourceToSkillToIndexMap = Maps.newHashMap();
        for (int i = 0; i < variables.size(); ++i) {
            RmUtils.addToKeyedMaps(resourceToSkillToIndexMap, variables.get(i).getResource(), variables.get(i).getSkill(), i);
        }
        return resourceToSkillToIndexMap;
    }

    public static class Builder {
        private float[] availabilities;
        private float[] demands;
        private boolean[][] resourceSkills;

        Builder(int r, int s) {
            this.availabilities = new float[r];
            this.demands = new float[s];
            this.resourceSkills = new boolean[r][s];
        }

        public Builder setAvailability(int r, float value) {
            this.availabilities[r] = value;
            return this;
        }

        public Builder setDemand(int s, float value) {
            this.demands[s] = value;
            return this;
        }

        public Builder setSkill(int r, int s) {
            this.resourceSkills[r][s] = true;
            return this;
        }

        public DefaultActivityAssignmentProblem build() {
            return new DefaultActivityAssignmentProblem(this.availabilities, this.demands, this.resourceSkills);
        }
    }
}

