/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IMutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableStageWorkPackageMapImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableAggregatedWorkPackage
implements IMutableAggregatedWorkPackage {
    private static final Log LOGGER = Log.with(MutableAggregatedWorkPackage.class);
    private final LinkedHashMap<IProcessingStage, MutableStageWorkPackage> stageToPositiveResourceDemandsMap;

    MutableAggregatedWorkPackage(LinkedHashMap<IProcessingStage, MutableStageWorkPackage> stageToPositiveResourceDemandsMap) {
        this.stageToPositiveResourceDemandsMap = stageToPositiveResourceDemandsMap;
    }

    @Override
    public void decrease(IAggregatedWorkPackage minuend) {
        Preconditions.checkNotNull((Object)minuend, (Object)"work package must not be null");
        LogUtil.debug(LOGGER, "decrease with work package: %s", minuend);
        List<IProcessingStage> stages = minuend.getSpecifiedStages();
        for (IProcessingStage stage : stages) {
            IProcessingStageWorkPackage workPackageForStage = (IProcessingStageWorkPackage)minuend.getWorkPackageForStage(stage).get();
            this.decrease(workPackageForStage);
        }
    }

    @Override
    public void decrease(IProcessingStageWorkPackage stageWorkPackage) {
        Preconditions.checkNotNull((Object)stageWorkPackage, (Object)"stage work package must not be null");
        LogUtil.debug(LOGGER, "decrease with stage work package: %s", stageWorkPackage);
        IProcessingStage processingStage = stageWorkPackage.getProcessingStage();
        PositivePrimitivesMap<IResourceType> minusAmounts = stageWorkPackage.getPositiveTypeAmounts();
        MutableStageWorkPackage stageDemands = this.stageToPositiveResourceDemandsMap.get(processingStage);
        stageDemands.decrease(minusAmounts);
        if (stageDemands.isEmpty()) {
            this.stageToPositiveResourceDemandsMap.remove(processingStage);
        }
        LogUtil.debug(LOGGER, "new stage demands: %s", stageDemands);
    }

    @Override
    public float getWorkAmountForStage(IProcessingStage stage) {
        Preconditions.checkNotNull((Object)stage, (Object)"processing stage must not be null");
        LogUtil.debug(LOGGER, "get work amount for stage: %s", stage);
        MutableStageWorkPackage stagePackage = this.stageToPositiveResourceDemandsMap.get(stage);
        if (stagePackage == null) {
            LogUtil.debug(LOGGER, "no demand for stage: %s - return 0", stage);
            return 0.0f;
        }
        float stageAmount = stagePackage.getAmount();
        LogUtil.debug(LOGGER, "return stage amount: %s", Float.valueOf(stageAmount));
        return stageAmount;
    }

    @Override
    public boolean isEmpty() {
        return this.stageToPositiveResourceDemandsMap.isEmpty();
    }

    @Override
    public List<IProcessingStage> getSpecifiedStages() {
        return Lists.newArrayList(this.stageToPositiveResourceDemandsMap.keySet());
    }

    @Override
    public Optional<MutableStageWorkPackage> getWorkPackageForStage(IProcessingStage stage) {
        return Optional.fromNullable((Object)this.stageToPositiveResourceDemandsMap.get(stage));
    }

    @Override
    public IAggregatedWorkPackage toImmutable() {
        return new ImmutableWrapper(this);
    }

    @Override
    public float getDemand() {
        float sum = 0.0f;
        for (MutableStageWorkPackage stageWorkPackage : this.stageToPositiveResourceDemandsMap.values()) {
            sum += stageWorkPackage.getAmount();
        }
        return sum;
    }

    public static MutableAggregatedWorkPackage createInstance(IAggregatedWorkPackage aggregatedWork) {
        Preconditions.checkNotNull((Object)aggregatedWork, (Object)"aggregated work package must not be null");
        LogUtil.debug(LOGGER, "create new mutable work package for: %s", aggregatedWork);
        LinkedHashMap positiveResourceDemandsMap = Maps.newLinkedHashMap();
        List<IProcessingStage> specifiedStages = aggregatedWork.getSpecifiedStages();
        for (IProcessingStage processingStage : specifiedStages) {
            IProcessingStageWorkPackage workPackageForStage = (IProcessingStageWorkPackage)aggregatedWork.getWorkPackageForStage(processingStage).get();
            MutableStageWorkPackage mutableAggregatedWorkPackage = MutableStageWorkPackageMapImpl.createInstance(workPackageForStage);
            positiveResourceDemandsMap.put(processingStage, mutableAggregatedWorkPackage);
        }
        MutableAggregatedWorkPackage instance = new MutableAggregatedWorkPackage(positiveResourceDemandsMap);
        LogUtil.debug(LOGGER, "created new instance: %s", instance);
        return instance;
    }

    public static IMutableAggregatedWorkPackage createInstance(Collection<IAggregatedWorkPackage> workPackages) {
        TreeMap stageToWorkPackageMap = Maps.newTreeMap((Comparator)new Comparator<IProcessingStage>(){

            @Override
            public int compare(IProcessingStage o1, IProcessingStage o2) {
                return this.compare(o1.getIndex(), o2.getIndex());
            }

            @Override
            private int compare(int x, int y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        for (IAggregatedWorkPackage workPackage : workPackages) {
            List<IProcessingStage> stages = workPackage.getSpecifiedStages();
            for (IProcessingStage stage : stages) {
                RmUtils.addToKeyedSets(stageToWorkPackageMap, stage, workPackage.getWorkPackageForStage(stage).get());
            }
        }
        LinkedHashMap<IProcessingStage, MutableStageWorkPackage> map = MutableAggregatedWorkPackage.create(stageToWorkPackageMap);
        MutableAggregatedWorkPackage mutableAggregatedWorkPackage = new MutableAggregatedWorkPackage(map);
        return mutableAggregatedWorkPackage;
    }

    private static LinkedHashMap<IProcessingStage, MutableStageWorkPackage> create(Map<IProcessingStage, Set<IProcessingStageWorkPackage>> m) {
        LinkedHashMap linkedMap = Maps.newLinkedHashMap();
        for (Map.Entry<IProcessingStage, Set<IProcessingStageWorkPackage>> entry : m.entrySet()) {
            linkedMap.put(entry.getKey(), MutableStageWorkPackageMapImpl.createInstance(entry.getValue()));
        }
        return linkedMap;
    }

    class ImmutableWrapper
    implements IAggregatedWorkPackage {
        private final MutableAggregatedWorkPackage wrapped;

        ImmutableWrapper(MutableAggregatedWorkPackage wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public List<IProcessingStage> getSpecifiedStages() {
            return this.wrapped.getSpecifiedStages();
        }

        @Override
        public Optional<IProcessingStageWorkPackage> getWorkPackageForStage(IProcessingStage stage) {
            return Optional.fromNullable((Object)((IProcessingStageWorkPackage)this.wrapped.stageToPositiveResourceDemandsMap.get(stage)));
        }

        @Override
        public Optional<IProcessingStage> getPreviousStage(IProcessingStage stage) {
            ArrayList stages = Lists.newArrayList(MutableAggregatedWorkPackage.this.stageToPositiveResourceDemandsMap.keySet());
            int stageIndex = stages.indexOf(stage);
            if (stageIndex <= 0) {
                return Optional.absent();
            }
            return Optional.of(stages.get(stageIndex - 1));
        }

        @Override
        public Optional<IProcessingStage> getNextStage(IProcessingStage stage) {
            ArrayList stages = Lists.newArrayList(MutableAggregatedWorkPackage.this.stageToPositiveResourceDemandsMap.keySet());
            int stageIndex = stages.indexOf(stage);
            if (stageIndex == -1 || stageIndex >= stages.size() - 1) {
                return Optional.absent();
            }
            return Optional.of(stages.get(stageIndex + 1));
        }

        @Override
        public float getDemand() {
            return this.wrapped.getDemand();
        }

        @Override
        public PositivePrimitivesMap<IResourceType> getPositiveTypeAmounts() {
            MutablePositivePrimitivesMap<IResourceType> map = RmCollectionUtils.newMutablePositiveMap();
            for (IProcessingStage stage : MutableAggregatedWorkPackage.this.stageToPositiveResourceDemandsMap.keySet()) {
                map.add(((MutableStageWorkPackage)MutableAggregatedWorkPackage.this.stageToPositiveResourceDemandsMap.get(stage)).getPositiveTypeAmounts());
            }
            return map;
        }

        @Override
        public Set<IResourceType> getResourceTypes() {
            HashSet types = Sets.newHashSet();
            for (MutableStageWorkPackage stage : MutableAggregatedWorkPackage.this.stageToPositiveResourceDemandsMap.values()) {
                types.addAll(stage.getResourceTypes());
            }
            return types;
        }
    }
}

