/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IMutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.SingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.AggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UnstructuredItemSchedule
implements IUnstructuredItemSchedule {
    private static final Log LOGGER = Log.with(UnstructuredItemSchedule.class);
    private final Map<IResourceGroup, ISingleResourceGroupAssignment> groupAssignments;
    private final String itemId;
    private final IIntegerInterval activeInterval;
    private final Map<IProcessingStage, Set<IWorkSlot>> stageToWorkSlotsMap;
    private final IAggregatedWorkPackage aggregatedWorkPackage;
    private final boolean itemCompleted;
    private final int releaseTime;

    UnstructuredItemSchedule(String itemId, Map<IResourceGroup, ISingleResourceGroupAssignment> groupAssignments, Map<IProcessingStage, Set<IWorkSlot>> stageToWorkSlotsMap, IIntegerInterval activeInterval, IAggregatedWorkPackage aggregatedWorkPackage, boolean itemCompleted, int releaseTime) {
        this.groupAssignments = groupAssignments;
        this.itemId = itemId;
        this.stageToWorkSlotsMap = stageToWorkSlotsMap;
        this.activeInterval = activeInterval;
        this.aggregatedWorkPackage = aggregatedWorkPackage;
        this.itemCompleted = itemCompleted;
        this.releaseTime = releaseTime;
    }

    @Override
    public int getStart() {
        return this.activeInterval.getStart();
    }

    @Override
    public int getEnd() {
        return this.activeInterval.getEnd();
    }

    @Override
    public String getId() {
        return this.itemId;
    }

    @Override
    public Set<IResourceGroup> getInvolvedResourceGroups() {
        return this.groupAssignments.keySet();
    }

    @Override
    public ISingleResourceGroupAssignment getWorkAssignmentsForGroup(IResourceGroup group) {
        return this.groupAssignments.get(group);
    }

    @Override
    public Map<IProcessingStage, Set<IWorkSlot>> getStageToWorkSlotsMap() {
        return this.stageToWorkSlotsMap;
    }

    @Override
    public int getLength() {
        return this.activeInterval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.activeInterval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.activeInterval.getOverlappingInterval(interval);
    }

    @Override
    public IAggregatedWorkPackage getAggregatedWorkPackage() {
        return this.aggregatedWorkPackage;
    }

    @Override
    public Map<IResourceGroup, ISingleResourceGroupAssignment> getGroupAssignments() {
        return this.groupAssignments;
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        HashSet union = Sets.newHashSet();
        for (ISingleResourceGroupAssignment assignment : this.groupAssignments.values()) {
            union = Sets.union((Set)union, assignment.getWorkAssignments());
        }
        return union;
    }

    @Override
    public boolean isItemCompleted() {
        return this.itemCompleted;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return Sets.newHashSet();
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }

    public static Optional<IUnstructuredItemSchedule> tryCreateFromPartialSchedules(Set<IProcessingStage> neededStages, Set<IUnstructuredItemSchedule> partialSchedules, boolean done) {
        LogUtil.debugCollection(LOGGER, "create instance from partial schedules: %s", partialSchedules);
        if (partialSchedules.isEmpty()) {
            return Optional.absent();
        }
        String id = partialSchedules.iterator().next().getId();
        Map<IResourceGroup, ISingleResourceGroupAssignment> assignments = UnstructuredItemSchedule.extractGroupAssignments(partialSchedules);
        IIntegerInterval interval = RmUtils.getMergedIntervals(partialSchedules);
        Map<IProcessingStage, Set<IWorkSlot>> stageToSlotsMap = UnstructuredItemSchedule.extractStageSlotsMap(assignments.values());
        ArrayList scheduleList = Lists.newArrayList(partialSchedules);
        ArrayList workPackages = Lists.newArrayList();
        for (IUnstructuredItemSchedule schedule : scheduleList) {
            workPackages.add(schedule.getAggregatedWorkPackage());
        }
        IMutableAggregatedWorkPackage aggregatedWork = MutableAggregatedWorkPackage.createInstance(workPackages);
        if (!aggregatedWork.getSpecifiedStages().containsAll(neededStages)) {
            return Optional.absent();
        }
        int itemReleaseTime = UnstructuredItemSchedule.getMinReleaseTime(partialSchedules);
        UnstructuredItemSchedule instance = new UnstructuredItemSchedule(id, assignments, stageToSlotsMap, interval, aggregatedWork.toImmutable(), done, itemReleaseTime);
        return Optional.of((Object)instance);
    }

    private static int getMinReleaseTime(Set<IUnstructuredItemSchedule> partialSchedules) {
        int releaseTime = Integer.MAX_VALUE;
        for (IUnstructuredItemSchedule partialSchedule : partialSchedules) {
            releaseTime = Math.min(releaseTime, partialSchedule.getReleaseTime());
        }
        return releaseTime;
    }

    public static IUnstructuredItemSchedule createDoneFromPartialSchedules(Set<IProcessingStage> neededStages, Set<IUnstructuredItemSchedule> partialSchedules) {
        return (IUnstructuredItemSchedule)UnstructuredItemSchedule.tryCreateFromPartialSchedules(neededStages, partialSchedules, true).get();
    }

    public static Optional<IUnstructuredItemSchedule> tryCreatePartialInstance(String id, Map<IResourceGroup, ISingleResourceGroupAssignment> assignments, int releaseTime) {
        Map<IProcessingStage, Set<IWorkSlot>> stageSlotsMap = UnstructuredItemSchedule.extractStageSlots(assignments.values());
        Optional<IAggregatedWorkPackage> aggregatedWork = AggregatedWorkPackage.tryCreateInstance(assignments.values());
        if (!aggregatedWork.isPresent()) {
            return Optional.absent();
        }
        UnstructuredItemSchedule instance = new UnstructuredItemSchedule(id, assignments, stageSlotsMap, RmUtils.getMergedIntervals(assignments.values()), (IAggregatedWorkPackage)aggregatedWork.get(), false, releaseTime);
        return Optional.of((Object)instance);
    }

    private static Map<IProcessingStage, Set<IWorkSlot>> extractStageSlotsMap(Collection<ISingleResourceGroupAssignment> assigments) {
        HashMap stageSlotsMap = Maps.newHashMap();
        for (ISingleResourceGroupAssignment assignment : assigments) {
            Set<IWorkAssignment> workAssignments = assignment.getWorkAssignments();
            for (IWorkAssignment workAssignment : workAssignments) {
                IWorkSlot workSlot = workAssignment.getWorkSlot();
                IProcessingStage stage = workAssignment.getProcessingStage();
                if (stageSlotsMap.containsKey(stage)) {
                    ((Set)stageSlotsMap.get(stage)).add(workSlot);
                    continue;
                }
                stageSlotsMap.put(stage, Sets.newHashSet((Object[])new IWorkSlot[]{workSlot}));
            }
        }
        return stageSlotsMap;
    }

    private static Map<IResourceGroup, ISingleResourceGroupAssignment> extractGroupAssignments(Set<IUnstructuredItemSchedule> partialSchedules) {
        HashMap allGroupAssignments = Maps.newHashMap();
        for (IUnstructuredItemSchedule partialSchedule : partialSchedules) {
            Map<IResourceGroup, ISingleResourceGroupAssignment> groupAssignments = partialSchedule.getGroupAssignments();
            for (Map.Entry<IResourceGroup, ISingleResourceGroupAssignment> groupAssignmentEntry : groupAssignments.entrySet()) {
                IResourceGroup group = groupAssignmentEntry.getKey();
                ISingleResourceGroupAssignment assignment = groupAssignmentEntry.getValue();
                if (!allGroupAssignments.containsKey(group)) {
                    allGroupAssignments.put(group, assignment);
                    continue;
                }
                SingleResourceGroupAssignment merged = SingleResourceGroupAssignment.merge(assignment, (ISingleResourceGroupAssignment)allGroupAssignments.get(group));
                allGroupAssignments.put(group, merged);
            }
        }
        return allGroupAssignments;
    }

    private static Map<IProcessingStage, Set<IWorkSlot>> extractStageSlots(Collection<ISingleResourceGroupAssignment> values) {
        HashMap stageSlotMap = Maps.newHashMap();
        for (ISingleResourceGroupAssignment assignment : values) {
            Set<IWorkAssignment> workAssignments = assignment.getWorkAssignments();
            for (IWorkAssignment workAssignment : workAssignments) {
                RmUtils.addToKeyedSets(stageSlotMap, workAssignment.getProcessingStage(), workAssignment.getWorkSlot());
            }
        }
        return stageSlotMap;
    }
}

