/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BoundAvailability
implements IIntegerInterval {
    private final IIntegerInterval interval;
    private final float availability;

    public BoundAvailability(int start, int end, float availability) {
        this(new IntegerInterval(start, end), availability);
    }

    public BoundAvailability(IIntegerInterval interval, float availability) {
        Preconditions.checkNotNull((Object)interval);
        Preconditions.checkArgument((interval.getLength() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument(((double)availability >= 0.0 ? 1 : 0) != 0);
        this.interval = interval;
        this.availability = availability;
    }

    public float getAvailability() {
        return this.availability;
    }

    @Override
    public int getStart() {
        return this.interval.getStart();
    }

    @Override
    public int getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public int getLength() {
        return this.interval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.interval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.interval.getOverlappingInterval(interval);
    }

    public String toString() {
        return this.interval + ":" + this.availability;
    }
}

