/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Preconditions;
import java.util.Set;

public class StageTask
implements IStageTask {
    private final String id;
    private final IProcessingStageWorkPackage workDemand;
    private final int releaseTime;
    private final AssignmentRestriction assignmentRestriction;

    public StageTask(String id, int releaseTime, IProcessingStageWorkPackage workDemand, AssignmentRestriction assignmentRestriction) {
        this.releaseTime = releaseTime;
        this.assignmentRestriction = assignmentRestriction;
        this.id = (String)Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((!workDemand.getPositiveTypeAmounts().isEmpty() ? 1 : 0) != 0);
        this.workDemand = workDemand;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getPositiveTypeAmounts() {
        return this.workDemand.getPositiveTypeAmounts();
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.workDemand.getPositiveTypeAmounts().keySet();
    }

    @Override
    public IProcessingStage getProcessingStage() {
        return this.workDemand.getProcessingStage();
    }

    @Override
    public float getAmount() {
        return this.workDemand.getAmount();
    }

    @Override
    public AssignmentRestriction getAssignmentRestriction() {
        return this.assignmentRestriction;
    }

    @Override
    public int getReleaseTime() {
        return this.releaseTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageTask stageTask = (StageTask)o;
        if (this.id != null ? !this.id.equals(stageTask.id) : stageTask.id != null) {
            return false;
        }
        return !(this.workDemand == null ? stageTask.workDemand != null : !this.workDemand.equals(stageTask.workDemand));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.workDemand != null ? this.workDemand.hashCode() : 0);
        return result;
    }
}

