/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.ISortable;
import com.atlassian.rm.jpo.scheduling.util.collection.FilteredKeysWrapper;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitiveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitivesWrapper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RmCollectionUtils {
    private RmCollectionUtils() {
    }

    public static <K> MapBuilder<K> builder() {
        return new MapBuilder();
    }

    public static <K> MutablePositivePrimitivesMap<K> newMutablePositiveMap() {
        return MutablePositiveTroveMap.create();
    }

    public static <K> MutablePositivePrimitivesMap<K> newMutablePositiveMap(int expectedSize) {
        return MutablePositiveTroveMap.createWithExpectedSize(expectedSize);
    }

    public static <K> MutablePositivePrimitivesMap<K> newMutablePositiveMap(PositivePrimitivesMap<K> inputMap) {
        return MutablePositiveTroveMap.create(inputMap);
    }

    public static <K> PositivePrimitivesMap<K> filterKeys(PositivePrimitivesMap<K> inputMap, Predicate<K> predicate) {
        return FilteredKeysWrapper.create(inputMap, predicate);
    }

    public static <K> Optional<ImmutableNonEmptyPositivePrimitivesMap<K>> tryCreate(Map<K, Float> inputMap) {
        return ImmutableNonEmptyPositiveTroveMap.tryCreate(inputMap);
    }

    public static <K extends ISortable> SortedPositivePrimitiveMap<K> getSortedMap(PositivePrimitivesMap<K> unsortedMap) {
        return SortedPositivePrimitivesWrapper.create(unsortedMap);
    }

    public static <K> Optional<ImmutableNonEmptyPositivePrimitivesMap<K>> tryCreate(PositivePrimitivesMap<K> inputMap) {
        return ImmutableNonEmptyPositiveTroveMap.tryCreate(inputMap);
    }

    public static <K> MutablePrimitivesMap<K> newMutableMap() {
        return MutablePrimitivesTroveMap.create();
    }

    public static <T> Set<T> getMergedSet(Iterable<Set<T>> sets) {
        HashSet merged = Sets.newHashSet();
        for (Set<T> set : sets) {
            merged = Sets.union((Set)merged, set);
        }
        return merged;
    }

    public static <T> Set<T> createMergedSet(Set<T> ... sets) {
        HashSet merged = Sets.newHashSet();
        for (Set<T> set : sets) {
            merged.addAll(set);
        }
        return merged;
    }

    public static <K> MutablePrimitivesMap<K> newMutableMap(int size) {
        return MutablePrimitivesTroveMap.create(size);
    }

    public static <T> List<List<T>> getPartitions(List<T> elements, int offset, int partitionSize) {
        if (elements.isEmpty()) {
            return Lists.newArrayList();
        }
        if (offset == 0) {
            return Lists.partition(elements, (int)partitionSize);
        }
        if (offset > elements.size()) {
            ArrayList list = Lists.newArrayList();
            list.add(elements);
            return list;
        }
        ArrayList partitions = Lists.newArrayList();
        partitions.add(elements.subList(0, offset));
        partitions.addAll(Lists.partition(elements.subList(offset, elements.size()), (int)partitionSize));
        return partitions;
    }

    public static <T> Optional<T> findFirst(Iterable<T> elements, Predicate<T> predicate) {
        for (T element : elements) {
            if (!predicate.apply(element)) continue;
            return Optional.of(element);
        }
        return Optional.absent();
    }

    public static class MapBuilder<K> {
        private final MutablePositivePrimitivesMap<K> map = RmCollectionUtils.newMutablePositiveMap();

        public MapBuilder<K> put(K key, float value) {
            this.map.put(key, value);
            return this;
        }

        public MutablePositivePrimitivesMap<K> build() {
            return this.map;
        }
    }
}

