/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.api;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.api.LicenseErrorType;
import com.radiantminds.roadmap.api.LicenseInformation;
import com.radiantminds.roadmap.api.LicenseService;
import com.radiantminds.roadmap.api.Portfolio1Exception;
import com.radiantminds.roadmap.common.api.DefaultLicenseInformation;
import com.radiantminds.roadmap.common.extensions.licenses.LicenseExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultApiLicenseService
implements LicenseService {
    private final LicenseExtension licenseExtension;

    @Autowired
    public DefaultApiLicenseService(LicenseExtension licenseExtension) {
        this.licenseExtension = licenseExtension;
    }

    @Override
    public LicenseInformation getLicenseInformation() throws Portfolio1Exception {
        try {
            LicenseData licenseData = this.licenseExtension.getLicenseData();
            if (licenseData.isValid()) {
                return new DefaultLicenseInformation((Optional<LicenseErrorType>)Optional.absent());
            }
            com.atlassian.rm.common.bridges.jira.license.LicenseErrorType errorType = licenseData.getErrorType();
            return new DefaultLicenseInformation((Optional<LicenseErrorType>)Optional.of((Object)((Object)LicenseErrorType.valueOf(errorType.name()))));
        }
        catch (Exception e) {
            throw new Portfolio1Exception(e);
        }
    }
}

