/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityChecker;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ICustomTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseIntegrityUtil
extends BaseTransactionalAOPersistenceSQL {
    private static final Log LOGGER = Log.with(DatabaseIntegrityUtil.class);
    private final List<DatabaseIntegrityChecker> integrityCheckers;

    @Autowired
    public DatabaseIntegrityUtil(ActiveObjectsUtilities activeObjectsUtilities, List<DatabaseIntegrityChecker> integrityCheckers) {
        super(activeObjectsUtilities);
        final HashMap requirements = Maps.newHashMap();
        for (DatabaseIntegrityChecker checker : integrityCheckers) {
            requirements.put(checker, DatabaseIntegrityUtil.getRecursiveRequirements(checker.getClass()));
        }
        Collections.sort(integrityCheckers, new Comparator<DatabaseIntegrityChecker>(){

            @Override
            public int compare(DatabaseIntegrityChecker o1, DatabaseIntegrityChecker o2) {
                if (((Set)requirements.get(o1)).contains(o2.getClass())) {
                    return 1;
                }
                if (((Set)requirements.get(o2)).contains(o1.getClass())) {
                    return -1;
                }
                return 0;
            }
        });
        this.integrityCheckers = integrityCheckers;
    }

    public void assertIntegrity(final String planId) throws Exception {
        LOGGER.info("Checking DB for integrity issues...", new Object[0]);
        this.inCustomTransaction(new ICustomTransaction<Void>(){

            @Override
            public Void execute(Connection connection) throws SQLException {
                for (DatabaseIntegrityChecker util : DatabaseIntegrityUtil.this.integrityCheckers) {
                    util.checkAndFix(planId, connection);
                }
                return null;
            }
        });
        LOGGER.info("Finished DB integrity check...", new Object[0]);
    }

    private static Set<Class> getRecursiveRequirements(Class<?> clazz) {
        HashSet retVal = Sets.newHashSet();
        DatabaseIntegrityConfiguration config = clazz.getAnnotation(DatabaseIntegrityConfiguration.class);
        if (config != null) {
            for (Class requirement : config.requires()) {
                if (retVal.contains(requirement)) continue;
                retVal.add(requirement);
                retVal.addAll(DatabaseIntegrityUtil.getRecursiveRequirements(requirement));
            }
        }
        return retVal;
    }
}

