/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.integrity.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ISortable;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.integrity.rank.BaseSortableIntegrityChecker;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkItemOrderRangeIdentifierIntegrityChecker
extends BaseSortableIntegrityChecker {
    private static final Log LOGGER = Log.with(WorkItemOrderRangeIdentifierIntegrityChecker.class);

    @Autowired
    public WorkItemOrderRangeIdentifierIntegrityChecker(ActiveObjectsUtilities activeObjectsUtilities) {
        super(LOGGER, activeObjectsUtilities);
    }

    @Override
    protected List<Class<? extends ISortable>> getApplicableTables() {
        return Lists.newArrayList((Object[])new Class[]{AOWorkItem.class});
    }

    @Override
    protected void checkClassForRankIntegrity(Connection connection, String planId, Class<? extends ISortable> clazz) throws SQLException {
        Set<String> idsWithoutIdentifier = this.getIdsWithoutIdentifiers(connection, planId);
        if (idsWithoutIdentifier.size() > 0) {
            for (String id : idsWithoutIdentifier) {
                LOGGER.warn("Found rank integrity issue: ID %s table %s has no order range identifier.", id, clazz);
                this.repairRangeIdentifier(connection, id);
            }
        }
    }

    private void repairRangeIdentifier(Connection connection, final String id) throws SQLException {
        Pair<String, Integer> repairFk = this.sql(new IQuery<Pair<String, Integer>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").select().col("t", "aoPlan").col("t", "type").from("t").where().colId("t").eq().numeric(id);
            }

            @Override
            public Pair<String, Integer> handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return Pair.create(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getInt(result, 2));
                }
                return null;
            }
        }, connection, false);
        if (repairFk.getFirst() == null) {
            LOGGER.error("Cannot repair order range identifier of item %s in table %s. Foreign key is null!", id, AOWorkItem.class);
            return;
        }
        final String orid = WorkItems.OrderRangeIdentifiers.forType(repairFk.getSecond()) + "-" + repairFk.getFirst();
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").update().tableNoAlias("t").set().colNoAlias("t", "orderRangeIdentifier").eq().str(orid).where().colIdNoAlias("t").eq().numeric(id);
            }
        }, connection, false);
    }

    private Set<String> getIdsWithoutIdentifiers(Connection connection, final String planId) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").withTable(AOWorkItem.class, "ti").select().colId("t").from("t").where().col("t", "aoPlan").eq().numeric(planId).and().col("t", "orderRangeIdentifier").isNull().and().raw("(").select().raw("COUNT(*)").from("ti").where().col("ti", "aoParent").eq().colId("t").raw(")").eq().numeric(0);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet ids = Sets.newHashSet();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        }, connection, false);
    }
}

