/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.threading;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.radiantminds.roadmap.common.extensions.threading.ThreadPoolExtension;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Component;

@Component
public class IndexedThreadPoolManager
implements ThreadPoolExtension {
    private static final Log LOGGER = Log.with(IndexedThreadPoolManager.class);
    private final Map<String, ExecutorService> executorServices = Maps.newHashMap();
    private final Map<String, ListeningExecutorService> listeningServices = Maps.newHashMap();

    @Override
    public ListeningExecutorService listeningExecutorService(String key, int poolSize) {
        if (!this.listeningServices.containsKey(key)) {
            LOGGER.info("Unknown thread pool requested with key '" + key + "'. Pool will be created.", new Object[0]);
            ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(poolSize));
            this.listeningServices.put(key, service);
        }
        return this.listeningServices.get(key);
    }

    @Override
    public ExecutorService executorService(String key, int poolSize) {
        if (!this.executorServices.containsKey(key)) {
            LOGGER.info("Unknown thread pool requested with key '" + key + "'. Pool will be created.", new Object[0]);
            ExecutorService service = Executors.newFixedThreadPool(poolSize);
            this.executorServices.put(key, service);
        }
        return this.executorServices.get(key);
    }

    @PreDestroy
    public void shutdown() {
        for (String key : this.executorServices.keySet()) {
            try {
                LOGGER.info("Shutting down thread pool with key '%s'...", key);
                this.executorServices.get(key).shutdown();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to shut down thread pool with key '%s'.", key);
                LOGGER.exception(ex, Log.LogLevel.WARN);
            }
        }
        for (String key : this.listeningServices.keySet()) {
            try {
                LOGGER.info("Shutting down thread pool with key '%s'...", key);
                this.listeningServices.get(key).shutdown();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to shut down thread pool with key '%s'.", key);
                LOGGER.exception(ex, Log.LogLevel.WARN);
            }
        }
    }
}

