/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.common;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.handlers.sync.SyncOperationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestItemResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessage;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestBulkItemResult {
    @XmlElement
    private List<RestItemResult> results = Lists.newArrayList();
    @XmlElement
    private List<RestMessage> globalErrors;
    @XmlElement
    private List<RestMessage> globalWarnings;

    public void addResult(RestItemResult result) {
        this.results.add(result);
    }

    public void addResults(List<RestItemResult> results) {
        this.results.addAll(results);
    }

    public List<RestItemResult> getResults() {
        return this.results;
    }

    public void addGlobalError(RestMessage error) {
        if (this.globalErrors == null) {
            this.globalErrors = Lists.newArrayList();
        }
        this.globalErrors.add(error);
    }

    public void addGlobalWarning(RestMessage warning) {
        if (this.globalWarnings == null) {
            this.globalWarnings = Lists.newArrayList();
        }
        this.globalWarnings.add(warning);
    }

    public static RestBulkItemResult fromSyncOperationResult(SyncOperationResult syncResult) {
        RestBulkItemResult retVal = new RestBulkItemResult();
        for (ViolationMessage message : syncResult.getGlobalViolations()) {
            if ("error".equals(message.getType())) {
                retVal.addGlobalError(RestMessage.fromViolationMessage(message));
                continue;
            }
            retVal.addGlobalWarning(RestMessage.fromViolationMessage(message));
        }
        for (String handled : syncResult.getProcessedItems()) {
            RestItemResult itemResult = new RestItemResult(handled);
            if (syncResult.getItemViolations().containsKey(handled)) {
                for (ViolationMessage message : syncResult.getItemViolations().get(handled)) {
                    if ("error".equals(message.getType())) {
                        itemResult.setError(message.getMessage());
                        continue;
                    }
                    itemResult.addWarning(RestMessage.fromViolationMessage(message));
                }
            }
            retVal.addResult(itemResult);
        }
        return retVal;
    }
}

