/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.persons;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.people.RestPerson;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PlanPersonServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllPersons(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response addPersonToPlan(EntityContext<IPlan> var1, RestPerson var2) throws Exception;

    public static class Impl
    implements PlanPersonServiceHandler {
        private final PortfolioPersonPersistence personPersistene;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPersonPersistence personPersistene, PortfolioWorkItemPersistence workItemPersistence) {
            this.personPersistene = personPersistene;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllPersons(EntityContext<IPlan> entityContext) throws Exception {
            List<IPerson> persons = this.personPersistene.listAllPersonsForPlan(entityContext.getEntityId(), true);
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestPerson.class, IPerson.class, persons), RestPerson.class));
        }

        @Override
        public Response addPersonToPlan(EntityContext<IPlan> entityContext, RestPerson newPerson) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOPerson.class, "plan", newPerson, new SubCollectionUtilsCallback.Adapter<IPlan, IPerson, RestPerson>(){

                @Override
                public void setParent(IPlan parent, IPerson entity) {
                    entity.setPlan(parent);
                }

                @Override
                public IPerson persist(IPerson entity) throws PersistenceException {
                    return personPersistene.persist(entity);
                }

                @Override
                public IPerson get(String id) throws Exception {
                    return (IPerson)personPersistene.get(id);
                }
            });
        }
    }
}

