/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.stages;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IPercentable;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import com.radiantminds.roadmap.common.rest.utils.PercentageUtils;
import java.util.List;
import javax.ws.rs.core.Response;

public interface StageServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllSkills(EntityContext<IStage> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response entryDelete(EntityContext<IStage> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response setPercentage(EntityContext<IStage> var1, Double var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rankSkill(EntityContext<IStage> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addSkillToStage(EntityContext<IStage> var1, RestSkill var2) throws Exception;

    public static class Impl
    implements StageServiceHandler {
        private static final Log LOGGER = Log.with(StageServiceHandler.class);
        private final PortfolioSkillPersistence skillPersistence;
        private final PortfolioStagePersistence stagePersistence;
        private final PortfolioPlanPersistence planPersistence;
        private final PortfolioExtensionLinkPersistence extensionLinkPersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioSkillPersistence skillPersistence, PortfolioStagePersistence stagePersistence, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence) {
            this.skillPersistence = skillPersistence;
            this.stagePersistence = stagePersistence;
            this.planPersistence = planPersistence;
            this.extensionLinkPersistence = extensionLinkPersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response setPercentage(EntityContext<IStage> entityContext, Double value) throws Exception {
            ModificationResult retVal = PercentageUtils.setPercentage((IPercentable)entityContext.getEntity(), value, IPercentableCallback.STAGE, this.stagePersistence);
            return entityContext.ok(retVal);
        }

        @Override
        public Response entryDelete(EntityContext<IStage> entityContext) throws Exception {
            this.stagePersistence.delete(entityContext.getEntityId(), false);
            try {
                this.extensionLinkPersistence.removeAllExtensionLinksWithKey(AOWorkItem.class, "jira-issue-stage-" + entityContext.getEntityId());
            }
            catch (Exception ex) {
                LOGGER.error("Failed to remove stage links for deleted stage.", new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
            PercentageUtils.adaptToItemRemoval(this.planPersistence.get(entityContext.getEntityInfo().getPlanId()), IPercentableCallback.STAGE, this.stagePersistence);
            return entityContext.ok();
        }

        @Override
        public Response getAllSkills(EntityContext<IStage> entityContext) throws Exception {
            List<ISkill> skills = this.skillPersistence.listCustom(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestSkill.class, ISkill.class, skills), RestSkill.class));
        }

        @Override
        public Response rankSkill(EntityContext<IStage> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOSkill.class, this.skillPersistence, "stage", rank);
        }

        @Override
        public Response addSkillToStage(EntityContext<IStage> entityContext, RestSkill newSkill) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOSkill.class, "stage", newSkill, new SubCollectionUtilsCallback.Adapter<IStage, ISkill, RestSkill>(){
                private ModificationResult persistResult = null;

                @Override
                public void setParent(IStage parent, ISkill entity) {
                    entity.setStage(parent);
                }

                @Override
                public ISkill persist(ISkill entity) throws Exception {
                    ISkill skill = skillPersistence.persist(entity);
                    this.persistResult = PercentageUtils.adaptToItemAdd(skill.getStage(), skill, IPercentableCallback.SKILL, skillPersistence);
                    stagePersistence.deleteAllStageAbilities(skill.getStage().getId());
                    return skill;
                }

                @Override
                public ISkill get(String id) throws Exception {
                    return (ISkill)skillPersistence.get(id);
                }

                @Override
                public ModificationResult buildModificationResult(ISkill stored) throws Exception {
                    return this.persistResult;
                }
            });
        }
    }
}

