/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.sync;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.handlers.sync.SyncResult;
import com.radiantminds.roadmap.common.handlers.sync.SyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.SyncServiceHandlerImpl;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.services.sync.RestSyncConfiguration;
import com.radiantminds.roadmap.common.rest.services.sync.RestSyncResult;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/sync")
@Component
public class SynchronizationRestService {
    private final SyncServiceHandler handler;

    @Autowired
    public SynchronizationRestService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, AnalyticsExtension analyticsExtension, WorkItemExtension workItemExtension, ReleaseExtension releaseExtension, Scheduling scheduling) {
        this.handler = handlerFactory.createProxy(SyncServiceHandler.class, new SyncServiceHandlerImpl(analyticsExtension, planPersistence, workItemPersistence, stagePersistence, releasePersistence, extensionLinkPersistence, workItemExtension, releaseExtension, scheduling), planPersistence);
    }

    @POST
    public Response sync(@PathParam(value="id") String planId, RestSyncConfiguration restConfig) throws Exception {
        restConfig.setPlanId(planId);
        EntityContext entityContext = EntityContext.from(planId);
        SyncResult result = this.handler.sync(entityContext, restConfig);
        RestSyncResult restResult = RestSyncResult.fromSyncResult(result);
        return ResponseBuilder.ok(restResult);
    }
}

