/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.status;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestBulkWorkItemStatus;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.status.WorkItemStatusServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/bulk/status")
@Component
public class WorkItemBulkStatusService {
    private final WorkItemStatusServiceHandler handler;

    @Autowired
    public WorkItemBulkStatusService(OperationExecutor operationExecutor, SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioTeamPersistence teamPersistence, PortfolioStreamPersistence streamPersistence, PortfolioPlanPersistence planPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this.handler = handlerFactory.createProxy(WorkItemStatusServiceHandler.class, new WorkItemStatusServiceHandler.Impl(operationExecutor, workItemPersistence, estimatePersistence, streamPersistence, teamPersistence, planPersistence, portfolioToJiraSyncExtension), workItemPersistence);
    }

    @PUT
    public Response setBulkStatus(@QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestBulkWorkItemStatus status) throws Exception {
        return this.handler.setStatusInBulk(BulkEntityContext.from(status.getIds(), expectedPlanVersion), status);
    }

    @PUT
    @Path(value="/replanning")
    public Response setBulkReplanningStatus(@QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestBulkWorkItemStatus status) throws Exception {
        return this.handler.setReplanningStatusInBulk(BulkEntityContext.from(status.getIds(), expectedPlanVersion), status);
    }
}

