/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableInterval;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferablePerson;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferablePlanConfiguration;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableStage;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableStream;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableTeam;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableWorkItem;
import java.util.LinkedHashMap;
import java.util.List;

public class TransferablePlan
implements SchedulingPlan {
    private String id;
    private Long schedulingVersion;
    private Long date;
    private List<TransferableStage> stages;
    private List<TransferableTeam> teams;
    private List<TransferableStream> streams;
    private LinkedHashMap<String, TransferableWorkItem> workItems;
    private List<TransferableInterval> nonWorkingDays;
    private LinkedHashMap<String, TransferablePerson> persons;
    private TransferablePlanConfiguration configuration;

    public TransferablePlan(SchedulingPlan plan) {
        if (plan instanceof TransferablePlan) {
            throw new RuntimeException("Bad developer: y u convert transferable plan to transferable plan?");
        }
        this.id = plan.getId();
        this.schedulingVersion = plan.getSchedulingVersion();
        this.date = (Long)plan.getDate().orNull();
        this.configuration = new TransferablePlanConfiguration(plan.getPlanConfiguration());
        this.stages = Lists.newArrayList();
        for (SchedulingStage schedulingStage : plan.getStages()) {
            this.stages.add(new TransferableStage(schedulingStage));
        }
        this.teams = Lists.newArrayList();
        for (SchedulingTeam schedulingTeam : plan.getTeams()) {
            this.teams.add(new TransferableTeam(schedulingTeam));
        }
        this.persons = Maps.newLinkedHashMap();
        for (SchedulingPerson schedulingPerson : plan.getPersons()) {
            this.persons.put(schedulingPerson.getId(), new TransferablePerson(schedulingPerson));
        }
        this.streams = Lists.newArrayList();
        for (SchedulingStream schedulingStream : plan.getStreams()) {
            this.streams.add(new TransferableStream(schedulingStream));
        }
        this.workItems = Maps.newLinkedHashMap();
        for (SchedulingWorkItem schedulingWorkItem : plan.getWorkItems()) {
            this.workItems.put(schedulingWorkItem.getId(), new TransferableWorkItem(schedulingWorkItem));
        }
        this.nonWorkingDays = Lists.newArrayList();
        for (SchedulingInterval schedulingInterval : plan.getNonWorkingDays()) {
            this.nonWorkingDays.add(new TransferableInterval(schedulingInterval));
        }
    }

    @Override
    public SchedulingConfig getPlanConfiguration() {
        return this.configuration;
    }

    @Override
    public Optional<? extends SchedulingWorkItem> getWorkItem(String id) {
        return Optional.fromNullable((Object)this.workItems.get(id));
    }

    @Override
    public Optional<Long> getDate() {
        return Optional.fromNullable((Object)this.date);
    }

    @Override
    public List<? extends SchedulingStream> getStreams() {
        return Lists.newArrayList(this.streams);
    }

    @Override
    public List<? extends SchedulingWorkItem> getWorkItems() {
        return Lists.newArrayList(this.workItems.values());
    }

    @Override
    public List<? extends SchedulingTeam> getTeams() {
        return this.teams;
    }

    @Override
    public List<? extends SchedulingStage> getStages() {
        return this.stages;
    }

    @Override
    public Long getSchedulingVersion() {
        return this.schedulingVersion;
    }

    @Override
    public List<? extends SchedulingInterval> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    @Override
    public Optional<? extends SchedulingPerson> getPerson(String personId) {
        return Optional.fromNullable((Object)this.persons.get(personId));
    }

    public List<? extends SchedulingPerson> getPersons() {
        return Lists.newArrayList(this.persons.values());
    }

    @Override
    public String getId() {
        return this.id;
    }
}

