/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IsWorkTimeStep;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class IsWorkingDayFunction
implements IsWorkTimeStep {
    private final Set<Integer> nonWorkingTimeSteps;

    IsWorkingDayFunction(Set<Integer> nonWorkingTimeSteps) {
        this.nonWorkingTimeSteps = nonWorkingTimeSteps;
    }

    @Override
    public boolean isWorkTimeStep(int timeStep) {
        return !this.nonWorkingTimeSteps.contains(timeStep);
    }

    static IsWorkingDayFunction createInstance(ITimeTransformer timeTransformer, List<? extends SchedulingInterval> nonWorkingDays) {
        HashSet nonWorkingTimeSteps = Sets.newHashSet();
        for (SchedulingInterval schedulingInterval : nonWorkingDays) {
            Optional<IIntegerInterval> nonWorkingInterval = timeTransformer.tryTransformUpperLimitOptionalInterval(schedulingInterval);
            if (!nonWorkingInterval.isPresent()) continue;
            for (int i = ((IIntegerInterval)nonWorkingInterval.get()).getStart(); i <= ((IIntegerInterval)nonWorkingInterval.get()).getEnd(); ++i) {
                nonWorkingTimeSteps.add(i);
            }
        }
        return new IsWorkingDayFunction(nonWorkingTimeSteps);
    }
}

