/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class WorkItemTransformationResult {
    private final Set<IScheduleViolation> violations;
    private final IProcessingItem processingItem;

    WorkItemTransformationResult(Set<IScheduleViolation> violations, @Nullable IProcessingItem processingItem) {
        Preconditions.checkArgument((violations.isEmpty() || processingItem == null ? 1 : 0) != 0);
        this.violations = Collections.unmodifiableSet(violations);
        this.processingItem = processingItem;
    }

    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    public Optional<IProcessingItem> getProcessingItem() {
        return Optional.fromNullable((Object)this.processingItem);
    }
}

