/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.timeline;

import org.javasimon.callback.lastsplits.CircularList;
import org.javasimon.callback.timeline.TimeRange;
import org.javasimon.callback.timeline.TimelineSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Timeline<TR extends TimeRange> {
    protected final CircularList<TR> timeRanges;
    protected final long timeRangeWidth;
    private TR lastTimeRange;

    protected Timeline(int capacity, long timeRangeWidth) {
        this.timeRanges = new CircularList(capacity);
        this.timeRangeWidth = timeRangeWidth;
    }

    protected abstract TR createTimeRange(long var1, long var3);

    protected final TR getOrCreateTimeRange(long timestamp) {
        TimeRange timeRange;
        if (this.lastTimeRange == null || timestamp > ((TimeRange)this.lastTimeRange).getEndTimestamp()) {
            long roundedTimestamp = timestamp - timestamp % this.timeRangeWidth;
            timeRange = (TimeRange)this.createTimeRange(roundedTimestamp, roundedTimestamp + this.timeRangeWidth);
            this.timeRanges.add((TR)timeRange);
            this.lastTimeRange = timeRange;
        } else if (timestamp >= ((TimeRange)this.lastTimeRange).getStartTimestamp()) {
            timeRange = (TimeRange)this.lastTimeRange;
        } else {
            timeRange = null;
            for (TimeRange oldTimeRange : this.timeRanges) {
                if (!oldTimeRange.containsTimestamp(timestamp)) continue;
                timeRange = oldTimeRange;
                break;
            }
        }
        return (TR)timeRange;
    }

    public abstract TimelineSample<TR> sample();
}

