/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.DefaultAvailableResourcePresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.DefaultUnavailableResourcePresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourcePresence;
import com.atlassian.rm.jpo.scheduling.util.function.BoundDiscreteBooleanFunction;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.AbsenceFunctionCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.IntervalUtils;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.PresenceFunctionCreator;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class ResourcePresenceFunctionCreator {
    private static final Log LOGGER = Log.with(ResourcePresenceFunctionCreator.class);
    private final TimeStepPresenceFunction timeStepPresenceFunction;
    private final AbsenceFunctionCreator absenceFunctionCreator;
    private final PresenceFunctionCreator presenceFunctionCreator;
    private final long zeroInstant;

    ResourcePresenceFunctionCreator(TimeStepPresenceFunction timeStepPresenceFunction, AbsenceFunctionCreator absenceFunctionCreator, PresenceFunctionCreator presenceFunctionCreator, long zeroInstant) {
        this.timeStepPresenceFunction = timeStepPresenceFunction;
        this.absenceFunctionCreator = absenceFunctionCreator;
        this.presenceFunctionCreator = presenceFunctionCreator;
        this.zeroInstant = zeroInstant;
    }

    ResourcePresenceFunctionCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(timeStepPresenceFunction, new AbsenceFunctionCreator(timeTransformer), new PresenceFunctionCreator(timeTransformer), timeTransformer.getInstant(0));
    }

    Optional<IStepWiseResourcePresence> createResourcePresenceFunction(List<? extends SchedulingInterval> presenceIntervals, List<? extends SchedulingInterval> absenceIntervals) {
        LOGGER.debug("create present function", new Object[0]);
        if (this.timeStepPresenceFunction.isAllDisabled()) {
            return Optional.absent();
        }
        List<? extends SchedulingInterval> filteredPresenceIntervals = IntervalUtils.filterValidTimelyIntervals(presenceIntervals, this.zeroInstant);
        if (!presenceIntervals.isEmpty() && filteredPresenceIntervals.isEmpty()) {
            LOGGER.debug("no valid presence intervals", new Object[0]);
            return Optional.absent();
        }
        Optional<? extends SchedulingInterval> maxOpenPresenceFunction = IntervalUtils.getMaxOpenInterval(filteredPresenceIntervals);
        if (this.isDefaultPresent(filteredPresenceIntervals, maxOpenPresenceFunction)) {
            BoundDiscreteBooleanFunction absenceFunction = this.absenceFunctionCreator.createAbsenceFunction(absenceIntervals, filteredPresenceIntervals, maxOpenPresenceFunction);
            DefaultAvailableResourcePresenceFunction availableFunction = new DefaultAvailableResourcePresenceFunction(this.timeStepPresenceFunction, (Optional<BoundDiscreteBooleanFunction>)Optional.fromNullable((Object)absenceFunction));
            LOGGER.debug("created default present function: %s", availableFunction);
            return Optional.of((Object)availableFunction);
        }
        BoundDiscreteBooleanFunction presenceFunction = this.presenceFunctionCreator.createPresenceFunction(filteredPresenceIntervals, absenceIntervals);
        if (presenceFunction == null) {
            return Optional.absent();
        }
        DefaultUnavailableResourcePresenceFunction availableFunction = new DefaultUnavailableResourcePresenceFunction(this.timeStepPresenceFunction, presenceFunction);
        LOGGER.debug("created default not present function: %s", availableFunction);
        return Optional.of((Object)availableFunction);
    }

    private boolean isDefaultPresent(List<? extends SchedulingInterval> filteredPresenceIntervals, Optional<? extends SchedulingInterval> maxOpenPresenceFunction) {
        return maxOpenPresenceFunction.isPresent() || filteredPresenceIntervals.isEmpty();
    }
}

