/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.CorruptIndexException;
import com.atlassian.rm.common.bridges.lucene.DocumentConsumer;
import com.atlassian.rm.common.bridges.lucene.IndexReader;
import com.atlassian.rm.common.bridges.lucene.IndexReader73;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.atlassian.rm.common.bridges.lucene.Query73;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TopDocs;

public class IndexSearcher73
implements IndexSearcher {
    private final org.apache.lucene.search.IndexSearcher indexSearcher;

    public IndexSearcher73(org.apache.lucene.search.IndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    @Override
    public void search(Query query, DocumentConsumer consumer) throws IOException {
        this.indexSearcher.search(((Query73)query).getLuceneValue(), (Collector)new CollectorDelegate(consumer));
    }

    @Override
    public void search(Query query, Query filter, DocumentConsumer consumer) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add(((Query73)query).getLuceneValue(), BooleanClause.Occur.MUST).add(((Query73)filter).getLuceneValue(), BooleanClause.Occur.FILTER).build();
        this.indexSearcher.search((org.apache.lucene.search.Query)booleanQuery, (Collector)new CollectorDelegate(consumer));
    }

    @Override
    public List<Integer> search(Query query, int limit) throws IOException {
        return this.search(query, new Query73.Factory().createMatchAllQuery(), limit);
    }

    @Override
    public List<Integer> search(Query query, Query filter, int limit) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add(((Query73)query).getLuceneValue(), BooleanClause.Occur.MUST).add(((Query73)filter).getLuceneValue(), BooleanClause.Occur.FILTER).build();
        TopDocs topDocs = this.indexSearcher.search((org.apache.lucene.search.Query)booleanQuery, limit);
        return Lists.transform(Arrays.asList(topDocs.scoreDocs), (Function)new Function<ScoreDoc, Integer>(){

            public Integer apply(ScoreDoc scoreDoc) {
                return scoreDoc.doc;
            }
        });
    }

    @Override
    public long totalHits(Query query, int limit) throws IOException {
        TopDocs topDocs = this.indexSearcher.search(((Query73)query).getLuceneValue(), limit);
        return topDocs.totalHits;
    }

    @Override
    public boolean isMatch(Query query, int documentPosition) throws IOException {
        try {
            return this.indexSearcher.explain(((Query73)query).getLuceneValue(), documentPosition).isMatch();
        }
        catch (org.apache.lucene.index.CorruptIndexException e) {
            throw new CorruptIndexException((Exception)((Object)e));
        }
    }

    @Override
    public IndexReader getIndexReader() {
        return new IndexReader73(this.indexSearcher.getIndexReader());
    }

    @Override
    public Query.Factory getQueryFactory() {
        return new Query73.Factory();
    }

    @Override
    public void close() {
    }

    private static class CollectorDelegate
    extends SimpleCollector {
        private final DocumentConsumer consumer;
        private IndexReader indexReader;
        private int positionBase;

        CollectorDelegate(DocumentConsumer consumer) {
            this.consumer = consumer;
        }

        protected void doSetNextReader(LeafReaderContext context) {
            this.indexReader = new IndexReader73((org.apache.lucene.index.IndexReader)context.reader());
            this.positionBase = context.docBase;
        }

        public void collect(int doc) throws IOException {
            this.consumer.consume(this.indexReader, this.positionBase, doc);
        }

        public boolean needsScores() {
            return false;
        }
    }
}

