/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IInsert;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IStatement;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ICustomTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;

public class BaseTransactionalAOPersistenceSQL
extends BaseAOPersistenceSQL {
    private final ActiveObjectsUtilities activeObjectsUtilities;

    public BaseTransactionalAOPersistenceSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdatesInTransaction(List<IUpdate> updates, Connection connection) throws SQLException {
        try {
            connection.setAutoCommit(false);
            for (IUpdate update : updates) {
                this.sql(update, connection, false);
            }
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
                DbUtils.closeQuietly(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInsertsInTransaction(List<IInsert> inserts) throws SQLException {
        Connection connection = null;
        try {
            connection = this.activeObjectsUtilities.getOrCreateConnection();
            connection.setAutoCommit(false);
            for (IInsert insert : inserts) {
                this.sql(insert, connection, false);
            }
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
                DbUtils.closeQuietly(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <TRetVal> TRetVal inCustomTransaction(ICustomTransaction<TRetVal> callback) throws SQLException {
        Connection connection = null;
        try {
            connection = this.activeObjectsUtilities.getOrCreateConnection();
            connection.setAutoCommit(false);
            TRetVal retVal = callback.execute(connection);
            connection.commit();
            TRetVal TRetVal = retVal;
            return TRetVal;
        }
        finally {
            if (connection != null) {
                DbUtils.closeQuietly(connection);
            }
        }
    }

    protected void executeStatementsInTransaction(List<IStatement> statements, Connection connection) throws SQLException {
        for (IStatement statement : statements) {
            if (statement instanceof IQuery) {
                this.sql((IQuery)statement, connection, false);
                continue;
            }
            if (!(statement instanceof IUpdate)) continue;
            this.sql((IUpdate)statement, connection, false);
        }
    }

    protected void handleInTransactionWithoutResults(List<IStatement> statements) throws SQLException {
        Connection connection = null;
        try {
            connection = this.activeObjectsUtilities.getOrCreateConnection();
            connection.setAutoCommit(false);
            this.executeStatementsInTransaction(statements, connection);
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
                DbUtils.closeQuietly(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <TQueryResult> List<TQueryResult> handleInTransaction(List<IQuery<TQueryResult>> queries) throws SQLException {
        ArrayList retVal = Lists.newArrayList();
        Connection connection = null;
        try {
            connection = this.activeObjectsUtilities.getOrCreateConnection();
            connection.setAutoCommit(false);
            for (IQuery<TQueryResult> query : queries) {
                TQueryResult result = this.sql(query, connection, false);
                retVal.add(result);
            }
            connection.commit();
            ArrayList arrayList = retVal;
            return arrayList;
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(true);
                DbUtils.closeQuietly(connection);
            }
        }
    }
}

