/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import java.util.Map;
import java.util.Set;

public class TeamTransformationResult
implements TeamsTransformationResult {
    private final BiMap<SchedulingTeam, IResourceGroup> teamMapping;
    private final Set<SchedulingTeam> ignoredTeams;
    private final Map<String, IResourceGroup> resourceGroups;

    public TeamTransformationResult(BiMap<SchedulingTeam, IResourceGroup> biMap, Set<SchedulingTeam> ignoredTeams) {
        this.teamMapping = biMap;
        this.ignoredTeams = ignoredTeams;
        this.resourceGroups = RmIdentifiableUtils.createIdMap(this.teamMapping.values());
    }

    @Override
    public BiMap<SchedulingTeam, IResourceGroup> getTeamGroupMapping() {
        return this.teamMapping;
    }

    @Override
    public Optional<IResourceGroup> tryGetResourceGroup(String id) {
        return Optional.fromNullable((Object)this.resourceGroups.get(id));
    }

    @Override
    public Set<SchedulingTeam> getIgnoredTeams() {
        return this.ignoredTeams;
    }

    @Override
    public Set<IResourceGroup> getResourceGroups() {
        return this.teamMapping.values();
    }
}

