/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.kanban;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroupFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.UnstructuredSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.PersonMapping;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.kanban.KanbanResourceTransformer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class KanbanTeamTransformer {
    private static final Log LOGGER = Log.with(KanbanTeamTransformer.class);
    private final KanbanResourceTransformer resourceTransformer;
    private final TimeStepPresenceFunction timeStepPresenceFunction;

    public KanbanTeamTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new KanbanResourceTransformer(timeTransformer, timeStepPresenceFunction), timeStepPresenceFunction);
    }

    KanbanTeamTransformer(KanbanResourceTransformer resourceTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.resourceTransformer = resourceTransformer;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    public Optional<IResourceGroup> tryCreateResourceGroup(SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, PersonMapping personMapping) {
        LOGGER.debug("create resource group from team: %s", team);
        if (this.timeStepPresenceFunction.isAllDisabled()) {
            return Optional.absent();
        }
        String id = team.getId();
        List<? extends SchedulingResource> resources = team.getResources();
        if (resources == null) {
            return Optional.absent();
        }
        UnstructuredSlotsDefinition workSlotDefinition = new UnstructuredSlotsDefinition(team.getId(), this.timeStepPresenceFunction);
        Set<IWorkResource> workResources = this.createWorkResources(resources, team, resourceTypeMapping, workSlotDefinition, personMapping);
        if (workResources.isEmpty()) {
            LOGGER.debug("team has no members - ignored", new Object[0]);
            return Optional.absent();
        }
        String sortKey = team.getSortOrder().toString();
        ResourceGroup resourceGroup = ResourceGroupFactory.createResourceGroup(id, workResources, workSlotDefinition, null, sortKey, false);
        LOGGER.debug("created resource group: %s", resourceGroup);
        return Optional.of((Object)resourceGroup);
    }

    private Set<IWorkResource> createWorkResources(List<? extends SchedulingResource> resources, SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, WorkSlotsDefinition workSlotsDefinition, PersonMapping personMapping) {
        LOGGER.debug("create multi resources from resources: %s", Joiner.on((String)",").join(resources));
        HashSet workResources = Sets.newHashSet();
        for (SchedulingResource schedulingResource : resources) {
            Optional<IWorkResource> workResource = this.resourceTransformer.tryCreateWorkResource(schedulingResource, (SchedulingPerson)personMapping.getPerson(schedulingResource.getPersonId()).get(), team, resourceTypeMapping, workSlotsDefinition);
            if (!workResource.isPresent()) continue;
            workResources.add(workResource.get());
        }
        LOGGER.debug("created multi resources: %s", Joiner.on((String)",").join((Iterable)workResources));
        return workResources;
    }
}

