/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridgeProxy;
import com.atlassian.rm.common.envtestutils.ProjectDefinition;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.WiredTestUtils;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.atlassian.rm.common.envtestutils.annotations.JiraRequirements;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.atlassian.rm.common.envtestutils.tools.IssueType;
import com.atlassian.test.categories.OnDemandAcceptanceTest;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.projects.IssueTypeData;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.extensions.projects.ProjectAccess;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import com.radiantminds.roadmap.common.extensions.projects.ProjectExtension;
import com.radiantminds.roadmap.common.extensions.projects.ProjectIssueTypeData;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.beans.factory.annotation.Autowired;

@Category(value={OnDemandAcceptanceTest.class})
public class ProjectExtensionTest
extends WiredTestCase {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final ProjectExtension projectExtension;
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;

    @Autowired
    public ProjectExtensionTest(ProjectExtension projectExtension, ProjectServiceBridgeProxy projectServiceBridgeProxy) {
        this.projectExtension = projectExtension;
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testExcluded() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertEquals((long)3L, (long)listProjectResult.getProjects().size());
        ListProjectResult excludedListProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, (Set)Sets.newHashSet((Object[])new Long[]{((ProjectData)listProjectResult.getProjects().get(0)).getId()}), true);
        Assert.assertEquals((long)2L, (long)excludedListProjectResult.getProjects().size());
        Assert.assertFalse((boolean)excludedListProjectResult.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @JiraRequirements(maxVersionExclusive="6.4.1")
    @AgileRequirements(installed=true)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class, ProjectExtensionTestProjectDefinitionScrum.class})
    public void testBaseRetrieval61() {
        this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter"}, 6, 6, true);
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true, maxVersionExclusive="6.7")
    @JiraRequirements(minVersionInclusive="6.4.1", maxVersionExclusive="7.0")
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class, ProjectExtensionTestProjectDefinitionScrum.class})
    public void testBaseRetrieval641() {
        this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter", "assignee"}, 6, 6, true);
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true, minVersionInclusive="6.7")
    @JiraRequirements(minVersionInclusive="6.4.1", maxVersionExclusive="7.0")
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class, ProjectExtensionTestProjectDefinitionScrum.class})
    public void testBaseRetrieval641WithAgile67() {
        this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter", "assignee"}, 4, 6, true);
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true)
    @JiraRequirements(minVersionInclusive="7.0")
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class, ProjectExtensionTestProjectDefinitionScrum.class})
    public void testBaseRetrieval70() {
        this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter"}, 4, 4, true);
    }

    private void testBaseRetrieval(String[] requiredFields, int expectedScrumIssueTypeCount, int expectedTotalIssueTypeCount, boolean hasScrumProject) {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertEquals((long)(hasScrumProject ? 4L : 3L), (long)listProjectResult.getProjects().size());
        Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
        Assert.assertNotNull((Object)listProjectResult.getEpicIssueType());
        Assert.assertNotNull((Object)listProjectResult.getStoryPointsField());
        Assert.assertNotNull((Object)listProjectResult.getEpicLabelField());
        Assert.assertNotNull((Object)listProjectResult.getEpicLinkField());
        ProjectData fooAProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

            public boolean apply(@Nullable ProjectData projectData) {
                return "FOOA".equals(projectData.getKey());
            }
        });
        Assert.assertEquals((Object)"FOOA", (Object)fooAProject.getKey());
        Assert.assertEquals((Object)"FOOA", (Object)fooAProject.getName());
        if (hasScrumProject) {
            final Project scrumProject = this.wiredIntegrationTestRule.getProject(ProjectExtensionTestProjectDefinitionScrum.class);
            ProjectData testDataProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

                public boolean apply(@Nullable ProjectData projectData) {
                    return scrumProject.getKey().equals(projectData.getKey());
                }
            });
            Assert.assertEquals((Object)scrumProject.getKey(), (Object)testDataProject.getKey());
            Assert.assertEquals((long)expectedScrumIssueTypeCount, (long)testDataProject.getIssueTypes().size());
            ProjectIssueTypeData bugIssueTypeData = (ProjectIssueTypeData)Iterables.find((Iterable)testDataProject.getIssueTypes(), (Predicate)new Predicate<ProjectIssueTypeData>(){

                public boolean apply(@Nullable ProjectIssueTypeData input) {
                    return IssueType.BUG.getName().equals(input.getName());
                }
            });
            Assert.assertEquals((long)requiredFields.length, (long)bugIssueTypeData.getRequiredFields().size());
            for (String requiredField : requiredFields) {
                Assert.assertTrue((boolean)bugIssueTypeData.getRequiredFields().contains(requiredField));
            }
            Assert.assertEquals((long)expectedTotalIssueTypeCount, (long)listProjectResult.getIssueTypes().size());
            IssueTypeData story = (IssueTypeData)Iterables.find((Iterable)listProjectResult.getIssueTypes(), (Predicate)new Predicate<IssueTypeData>(){

                public boolean apply(@Nullable IssueTypeData input) {
                    return input.getName().equals("Story");
                }
            });
            Assert.assertEquals((Object)"Story", (Object)story.getName());
            Assert.assertTrue((boolean)story.getIconUrl().startsWith("http://"));
            Assert.assertFalse((boolean)story.isSubTask());
            Assert.assertTrue((boolean)story.isStoryPointsEnabled());
        }
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testLimitedRetrieval() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, Integer.valueOf(2), null, true);
        Assert.assertEquals((long)2L, (long)listProjectResult.getProjects().size());
        Assert.assertTrue((boolean)listProjectResult.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testQueryStringRetrieval() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, "FOO", null, null, true);
        Assert.assertEquals((long)3L, (long)listProjectResult.getProjects().size());
        Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testDefaultedProjectAccessWithoutDefault() {
        ProjectService.GetProjectResult getProjectResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).getProjectByKey(this.wiredIntegrationTestRule.getLoggedInUser(), "FOOA");
        ListProjectResult listProjectResult = this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
        Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testDefaultedProjectAccessWithDefault() {
        long nonExistentId = 999999L;
        ListProjectResult listProjectResult = this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, Long.valueOf(999999L), true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
        Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testDefaultedProjectWithRequiredFields() {
        ProjectService.GetProjectResult getProjectResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).getProjectByKey(this.wiredIntegrationTestRule.getLoggedInUser(), "FOOA");
        ListProjectResult listProjectResult = this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
        Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("summary"));
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("issuetype"));
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("reporter"));
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testDefaultedProjectWithoutRequiredFields() {
        ProjectService.GetProjectResult getProjectResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).getProjectByKey(this.wiredIntegrationTestRule.getLoggedInUser(), "FOOA");
        ListProjectResult listProjectResult = this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), false);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
        Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
        Assert.assertEquals((long)0L, (long)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().size());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testListProjectsWithRequiredFields() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("summary"));
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("issuetype"));
        Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("reporter"));
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinition2.class, ProjectExtensionTestProjectDefinition3.class})
    public void testListProjectsWithoutRequiredFields() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, false);
        Assert.assertEquals((long)0L, (long)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class, ProjectExtensionTestProjectDefinitionScrum.class})
    public void testSecurityReadAccessWithAgile() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertEquals((long)2L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=false)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class})
    public void testSecurityReadAccessNoAgile() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class})
    public void testSecurityWriteAccessWithAgile() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.CREATE_ISSUES, null, null, null, true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=false)
    public void testSecurityWriteAccessNoAgile() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.CREATE_ISSUES, null, null, null, true);
        Assert.assertEquals((long)0L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @Projects(value={ProjectExtensionTestProjectDefinition1.class})
    public void testSecurityWriteAccessForAdminAccess() {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.ADMINISTRATE, null, null, null, true);
        Assert.assertEquals((long)0L, (long)listProjectResult.getProjects().size());
    }

    private static class ProjectExtensionTestProjectDefinitionScrum
    implements ProjectDefinition {
        private final String PROJECT_KEY = "FOOSCRUM";

        private ProjectExtensionTestProjectDefinitionScrum() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            Project project = utils.getProjectUtils().createScrumProject(utils.getUserUtils().getAdminUser(), "FOOSCRUM", "FOOSCRUM");
            return project;
        }
    }

    private static class ProjectExtensionTestProjectDefinition3
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "FOOC";

        private ProjectExtensionTestProjectDefinition3() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }

    private static class ProjectExtensionTestProjectDefinition2
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "FOOB";

        private ProjectExtensionTestProjectDefinition2() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }

    private static class ProjectExtensionTestProjectDefinition1
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "FOOA";

        private ProjectExtensionTestProjectDefinition1() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }
}

