/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl;

import com.atlassian.fugue.Effect;
import com.atlassian.pocketknife.api.querydsl.ClosePromise;
import com.atlassian.pocketknife.api.querydsl.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.TupleMapper;
import com.atlassian.pocketknife.internal.querydsl.CloseableIterableImpl;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.NumberExpression;
import java.math.BigDecimal;

public class Tuples {
    private static final TupleMapper tupleMapple = new TupleMapper();

    public static <T> CloseableIterable<T> map(CloseableIterator<Tuple> closeableIterator, Function<Tuple, T> f) {
        return new CloseableIterableImpl<Tuple, T>(closeableIterator, f, ClosePromise.NOOP());
    }

    public static <T> CloseableIterable<T> map(CloseableIterator<Tuple> closeableIterator, Function<Tuple, T> f, ClosePromise closePromise) {
        return new CloseableIterableImpl<Tuple, T>(closeableIterator, f, closePromise);
    }

    public static <T> CloseableIterable<T> take(CloseableIterator<Tuple> closeableIterator, Function<Tuple, T> f, ClosePromise closePromise, int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"take(n) must be >= 0");
        Predicate nTaken = CloseableIterableImpl.nTakenPredicate(n);
        return Tuples.takeWhile(closeableIterator, f, closePromise, nTaken);
    }

    public static <T> CloseableIterable<T> takeWhile(CloseableIterator<Tuple> closeableIterator, Function<Tuple, T> f, ClosePromise closePromise, Predicate<Tuple> takeWhilePredicate) {
        return new CloseableIterableImpl<Tuple, T>(closeableIterator, f, closePromise, Predicates.alwaysTrue(), takeWhilePredicate);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterator<Tuple> closeableIterator, Function<Tuple, T> f, ClosePromise closePromise, Predicate<Tuple> filterPredicate) {
        return new CloseableIterableImpl<Tuple, T>(closeableIterator, f, closePromise, filterPredicate, Predicates.alwaysTrue());
    }

    public static void foreach(CloseableIterator<Tuple> closeableIterator, Effect<Tuple> effect) {
        Tuples.foreach(closeableIterator, effect, ClosePromise.NOOP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void foreach(CloseableIterator<Tuple> closeableIterator, Effect<Tuple> effect, ClosePromise closePromise) {
        try {
            while (closeableIterator.hasNext()) {
                Tuple t = (Tuple)closeableIterator.next();
                effect.apply((Object)t);
            }
        }
        finally {
            Tuples.closeQuietly(closeableIterator);
            closePromise.close();
        }
    }

    public static <T> Function<Tuple, T> column(Expression<T> expr) {
        return tupleMapple.column(expr);
    }

    public static <T extends Number> Function<Tuple, BigDecimal> toBigDecimal(NumberExpression<T> expr) {
        return tupleMapple.toBigDecimal(expr);
    }

    public static <T extends Number> Function<Tuple, Long> toLong(NumberExpression<T> expr) {
        return tupleMapple.toLong(expr);
    }

    public static <T extends Number> Function<Tuple, Float> toFloat(NumberExpression<T> expr) {
        return tupleMapple.toFloat(expr);
    }

    public static <T extends Number> Function<Tuple, Integer> toInt(NumberExpression<T> expr) {
        return tupleMapple.toInt(expr);
    }

    public static <T extends Number> Function<Tuple, Double> toDouble(NumberExpression<T> expr) {
        return tupleMapple.toDouble(expr);
    }

    private static void closeQuietly(CloseableIterator<Tuple> closeableIterator) {
        try {
            closeableIterator.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

