/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lucene;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lucene.ReindexingBridge;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lucene.JiraReindexingBridgeImpl")
@SupportedVersions(all=true)
public class JiraReindexingBridgeImpl
implements ReindexingBridge {
    private final JiraAuthenticationContext authenticationContext;
    private final ReindexMessageManager reindexMessageManager;

    @Autowired
    public JiraReindexingBridgeImpl(JiraAuthenticationContext authenticationContext, ReindexMessageManager reindexMessageManager) {
        this.authenticationContext = authenticationContext;
        this.reindexMessageManager = reindexMessageManager;
    }

    @Override
    public void requestDelayedReindexing(String message) {
        this.reindexMessageManager.pushMessage(this.authenticationContext.getLoggedInUser(), message);
    }
}

