/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.threading;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.threading.JiraSafeThreadService")
class JiraSafeThreadService {
    private static final Logger LOGGER = LogManager.getLogger(JiraSafeThreadService.class);
    private final JiraAuthenticationContext authenticationContext;
    private final JiraThreadLocalUtil threadLocalUtil;

    @Autowired
    JiraSafeThreadService(JiraAuthenticationContext authenticationContext, JiraThreadLocalUtil threadLocalUtil) {
        this.authenticationContext = authenticationContext;
        this.threadLocalUtil = threadLocalUtil;
    }

    public Future<String> execute(ExecutorService executorService, Callable<String> callable) {
        ApplicationUser executingUser = this.authenticationContext.getUser();
        return executorService.submit(() -> {
            this.threadLocalUtil.preCall();
            try {
                this.authenticationContext.setLoggedInUser(executingUser);
                String string = (String)callable.call();
                return string;
            }
            finally {
                this.threadLocalUtil.postCall(LOGGER);
            }
        });
    }
}

