/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.BoundDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class ActivitySetWaitingFunctionCalculator {
    ActivitySetWaitingFunctionCalculator() {
    }

    Map<IResourceType, IBoundedDiscreteStepFunction> getWaitingFunctions(IActivitySetSchedule activitySetSchedule) {
        HashMap waitingFunctions = Maps.newHashMap();
        Set<IActivitySchedule> activitySchedules = activitySetSchedule.getActivitySchedules();
        for (IActivitySchedule activitySchedule : activitySchedules) {
            Map<IResourceType, IBoundedDiscreteStepFunction> activityWaitingFunctions = this.getWaitingFunctions(activitySchedule);
            waitingFunctions.putAll(activityWaitingFunctions);
        }
        return waitingFunctions;
    }

    private Map<IResourceType, IBoundedDiscreteStepFunction> getWaitingFunctions(IActivitySchedule activitySchedule) {
        HashMap waitingMap = Maps.newHashMap();
        IActivity activity = activitySchedule.getActivity();
        Set<IResourceType> specifiedResourceTypes = activity.getResourceTypes();
        for (IResourceType resourceType : specifiedResourceTypes) {
            IBoundedDiscreteStepFunction waitingFunction = this.calculateWaitingWorkFunction(resourceType, activitySchedule);
            waitingMap.put(resourceType, waitingFunction);
        }
        return waitingMap;
    }

    private IBoundedDiscreteStepFunction calculateWaitingWorkFunction(IResourceType type, IActivitySchedule activitySchedule) {
        int endTime = activitySchedule.getEnd();
        BoundDiscreteStepFunction waitingFunction = new BoundDiscreteStepFunction(endTime);
        int releaseTime = activitySchedule.getReleaseTime();
        IActivity activity = activitySchedule.getActivity();
        float amount = activity.getPositiveTypeAmounts().get(type);
        waitingFunction.addBetween(releaseTime, endTime, amount);
        Set<IWorkSlot> usedWorkSlots = activitySchedule.getUsedWorkSlots();
        for (IWorkSlot workSlot : usedWorkSlots) {
            Set<IWorkAssignment> containedIntervals = this.getAssignmentsOfSlot(workSlot, type, activitySchedule.getWorkAssignments());
            float slotSum = 0.0f;
            for (IWorkAssignment iWorkAssignment : containedIntervals) {
                slotSum += iWorkAssignment.getAssignedWorkUnits();
            }
            waitingFunction.addBetween(workSlot.getStart(), endTime, -slotSum);
        }
        return waitingFunction;
    }

    private Set<IWorkAssignment> getAssignmentsOfSlot(IWorkSlot workSlot, IResourceType type, Set<IWorkAssignment> workAssignments) {
        HashSet assignments = Sets.newHashSet();
        for (IWorkAssignment workAssignment : workAssignments) {
            if (!workAssignment.getWorkSlot().equals(workSlot) || !type.equals(workAssignment.getResourceType())) continue;
            assignments.add(workAssignment);
        }
        return assignments;
    }
}

