/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IUnstructuredStageProfile;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

class UnstructuredStageProfile
implements IUnstructuredStageProfile {
    private final IBoundedDiscreteStepFunction stageDone;
    private final IBoundedDiscreteStepFunction stageEligible;
    private final double minWorkLoad;

    UnstructuredStageProfile(IBoundedDiscreteStepFunction stageDone, IBoundedDiscreteStepFunction stageEligible, double minWorkLoad) {
        Preconditions.checkArgument((stageDone.getBound() == stageEligible.getBound() ? 1 : 0) != 0);
        this.stageDone = stageDone;
        this.stageEligible = stageEligible;
        this.minWorkLoad = minWorkLoad;
    }

    @Override
    public Optional<Float> getEligibleStageAmount(int timeStep) {
        if (timeStep > this.stageDone.getBound()) {
            return Optional.absent();
        }
        float eligible = ((Float)this.stageEligible.getAt(timeStep).get()).floatValue() - ((Float)this.stageDone.getAt(timeStep).get()).floatValue();
        float diffToEnd = ((Float)this.stageDone.getAt(this.stageEligible.getBound()).get()).floatValue() - ((Float)this.stageDone.getAt(timeStep).get()).floatValue();
        if ((double)diffToEnd <= this.minWorkLoad) {
            return Optional.of((Object)Float.valueOf(eligible));
        }
        if ((double)eligible < this.minWorkLoad) {
            return Optional.of((Object)Float.valueOf(0.0f));
        }
        return Optional.of((Object)Float.valueOf(eligible));
    }

    IBoundedDiscreteStepFunction getDoneFunction() {
        return this.stageDone;
    }

    IBoundedDiscreteStepFunction getStageEligible() {
        return this.stageEligible;
    }

    double getMinWorkLoad() {
        return this.minWorkLoad;
    }
}

