/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class ActivitySetScheduleEvaluation
implements IActivitySetScheduleEvaluation {
    @Override
    public boolean isFirstBetterScheduleThanSecond(Optional<IActivitySetSchedule> first, Optional<IActivitySetSchedule> second) {
        int secondWarningCount;
        Preconditions.checkNotNull(first, (Object)"schedule must not be null");
        Preconditions.checkNotNull(second, (Object)"schedule must not be null");
        if (!first.isPresent()) {
            return false;
        }
        if (!second.isPresent()) {
            return true;
        }
        int firstWarningCount = this.getCountingWarningsFor((IActivitySetSchedule)first.get());
        if (firstWarningCount < (secondWarningCount = this.getCountingWarningsFor((IActivitySetSchedule)second.get()))) {
            return true;
        }
        if (secondWarningCount < firstWarningCount) {
            return false;
        }
        return ((IActivitySetSchedule)first.get()).getEnd() < ((IActivitySetSchedule)second.get()).getEnd();
    }

    private int getCountingWarningsFor(IActivitySetSchedule schedule) {
        if (!schedule.getResourceGroup().isWorkSlotStrict()) {
            return 0;
        }
        return schedule.getWarnings().size();
    }
}

