/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;

public class AnnotatedResult<T> {
    private final T result;
    private final Set<IScheduleViolation> violations;
    private final Set<IScheduleWarning> warnings;

    private AnnotatedResult(T dependencyDefinition, Set<IScheduleViolation> violations, Set<IScheduleWarning> warnings) {
        this.result = dependencyDefinition;
        this.violations = violations;
        this.warnings = warnings;
    }

    public T getResult() {
        return this.result;
    }

    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("result", this.result).add("violations", (Object)Iterables.toString(this.violations)).add("warnings", (Object)Iterables.toString(this.warnings)).toString();
    }

    public static class Builder<T> {
        private Set<IScheduleViolation> violations = Sets.newHashSet();
        private Set<IScheduleWarning> warnings = Sets.newHashSet();

        public Builder<T> addWarning(IScheduleWarning warning) {
            this.warnings.add(warning);
            return this;
        }

        public Builder<T> addWarnings(Set<IScheduleWarning> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        public AnnotatedResult<T> build(T dependencyDefinition) {
            return new AnnotatedResult(dependencyDefinition, this.violations, this.warnings);
        }
    }
}

