/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IStageRestrictionViolationDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.ResourceCountRestrictionViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.uncommons.maths.combinatorics.CombinationGenerator;

public class StageRestrictionViolationDetector
implements IStageRestrictionViolationDetector {
    private final long maxResourcesPerStage;

    public StageRestrictionViolationDetector(long maxResourcesPerStage) {
        this.maxResourcesPerStage = maxResourcesPerStage;
    }

    @Override
    public Optional<IScheduleViolation> tryFindRestrictionViolation(String workItemId, IAggregatedWorkPackage workDemand, AssignmentRestriction assignment) {
        for (IResourcePool pool : assignment.getResourcePools()) {
            Set<IWorkResource> resources = pool.getResources();
            if (!this.isAssignmentPossible(resources, workDemand)) continue;
            return Optional.absent();
        }
        ResourceCountRestrictionViolation scheduleViolation = new ResourceCountRestrictionViolation(workItemId);
        return Optional.of((Object)scheduleViolation);
    }

    private boolean isAssignmentPossible(Set<IWorkResource> resources, IAggregatedWorkPackage workDemand) {
        List<IProcessingStage> stages = workDemand.getSpecifiedStages();
        for (IProcessingStage stage : stages) {
            IProcessingStageWorkPackage stageDemand = (IProcessingStageWorkPackage)workDemand.getWorkPackageForStage(stage).get();
            if (this.isAssignmentPossible(resources, stageDemand)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignmentPossible(Set<IWorkResource> resources, IProcessingStageWorkPackage stageDemand) {
        Set<Set<IResourceType>> typeSubsets = this.extractTypeSubsets(resources);
        CombinationGenerator<Set<IResourceType>> combinator = new CombinationGenerator<Set<IResourceType>>(typeSubsets, Math.min(typeSubsets.size(), Ints.saturatedCast((long)this.maxResourcesPerStage)));
        while (combinator.hasMore()) {
            List<Set<IResourceType>> combination = combinator.nextCombinationAsList();
            Set<IResourceType> allAvailables = RmUtils.mergeToSet(combination);
            if (!allAvailables.containsAll(stageDemand.getResourceTypes())) continue;
            return true;
        }
        return false;
    }

    private Set<Set<IResourceType>> extractTypeSubsets(Set<IWorkResource> resources) {
        HashSet sets = Sets.newHashSet();
        for (IWorkResource resource : resources) {
            Set<IResourceType> resourceTypes = resource.getResourceTypes();
            sets.add(resourceTypes);
        }
        return sets;
    }
}

