/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConstantPositiveAvailability
implements IWorkSlotFunction {
    private final float availability;
    private final WorkSlotsDefinition slotsDefinition;

    public ConstantPositiveAvailability(float availability, WorkSlotsDefinition slotsDefinition) {
        Preconditions.checkArgument((availability > 0.0f ? 1 : 0) != 0);
        this.availability = availability;
        this.slotsDefinition = (WorkSlotsDefinition)Preconditions.checkNotNull((Object)slotsDefinition);
    }

    @Override
    public int getFirstRegularTimeStep() {
        return 0;
    }

    @Override
    public boolean isPositiveEnding() {
        return true;
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        if (this.slotsDefinition.isRestrictedWorkSlot(slotIndex)) {
            return 0.0f;
        }
        return this.availability;
    }

    @Override
    public float getRestrictedAvailability(int index) {
        return this.availability;
    }

    public String toString() {
        return "ConstantPositiveAvailability{availability=" + this.availability + ", slotsDefinition=" + this.slotsDefinition + '}';
    }
}

