/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Resource
implements IWorkResource {
    private final String id;
    private final String groupId;
    private final ImmutableNonEmptyPositivePrimitivesMap<IResourceType> resourceSupplyMap;
    private final IWorkSlotFunction workSlotFunction;
    private final String title;
    private final String sortKey;

    public Resource(String id, String groupId, ImmutableNonEmptyPositivePrimitivesMap<IResourceType> resourceSupplyMap, IWorkSlotFunction availabilityFunction, String title, String sortKey) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"multi resource id must not be null");
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"group id must not be null");
        this.resourceSupplyMap = (ImmutableNonEmptyPositivePrimitivesMap)Preconditions.checkNotNull(resourceSupplyMap, (Object)"resource supply must not be null");
        this.workSlotFunction = (IWorkSlotFunction)Preconditions.checkNotNull((Object)availabilityFunction, (Object)"availability function must not be null");
        this.sortKey = (String)Preconditions.checkNotNull((Object)sortKey, (Object)"the sort key must not be null");
        this.title = title;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getTypeSupplies() {
        return this.resourceSupplyMap;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.resourceSupplyMap.keySet();
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        return this.workSlotFunction.getUnassignedWorkInWorkSlot(slotIndex);
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        return this.workSlotFunction.getRestrictedAvailability(slotIndex);
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.workSlotFunction.getFirstRegularTimeStep();
    }

    @Override
    public boolean isUnlimitedAvailable() {
        return this.workSlotFunction.isPositiveEnding();
    }

    @Override
    public boolean isAvailableInWorkSlot(int slotIndex) {
        return this.workSlotFunction.getUnassignedWorkInWorkSlot(slotIndex) >= 0.01f;
    }

    @Override
    public boolean isPositiveEnding() {
        return this.workSlotFunction.isPositiveEnding();
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    public String toString() {
        return "Resource [id=" + this.id + ", title=" + this.title + "]";
    }
}

