/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.PreconditionUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Episode
implements IEpisode {
    private final String id;
    private final Integer fixedStartTime;
    private final Integer fixedEndTime;
    private final Integer startGap;
    private final String title;
    private final String streamId;
    private final boolean laterRelease;

    public Episode(String id, @Nullable Integer fixedStartTime, @Nullable Integer fixedEndTime, @Nullable Integer startGap, @Nullable String title, String streamId, boolean laterRelease) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        this.fixedStartTime = PreconditionUtils.checkArgumentNullableNonNegative(fixedStartTime);
        this.fixedEndTime = PreconditionUtils.checkArgumentNullableNonNegative(fixedEndTime);
        this.startGap = startGap;
        this.title = title;
        this.streamId = (String)Preconditions.checkNotNull((Object)streamId, (Object)"stream id must not be null");
        this.laterRelease = laterRelease;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<Integer> getFixedEndTime() {
        return Optional.fromNullable((Object)this.fixedEndTime);
    }

    @Override
    public Optional<Integer> getFixedStartTime() {
        return Optional.fromNullable((Object)this.fixedStartTime);
    }

    @Override
    public Optional<Integer> getStartGap() {
        return Optional.fromNullable((Object)this.startGap);
    }

    @Override
    public Optional<String> getTitle() {
        return Optional.fromNullable((Object)this.title);
    }

    @Override
    public boolean isFixedScope() {
        return this.fixedEndTime == null;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public boolean isLaterRelease() {
        return this.laterRelease;
    }

    @Override
    public boolean hasDefinedTimeSpan() {
        return (this.getFixedStartTime().isPresent() || !this.getStartGap().isPresent()) && this.getFixedEndTime().isPresent();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("fixedStartTime", (Object)this.fixedStartTime).add("fixedEndTime", (Object)this.fixedEndTime).add("startGap", (Object)this.startGap).add("title", (Object)this.title).add("streamId", (Object)this.streamId).add("laterRelease", this.laterRelease).toString();
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }
}

