/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ProcessingItems {
    public static List<IProcessingItem> sortBasedOnItemPriority(Collection<IProcessingItem> items) {
        ArrayList itemsList = Lists.newArrayList(items);
        Collections.sort(itemsList, new Comparator<IProcessingItem>(){

            @Override
            public int compare(IProcessingItem o1, IProcessingItem o2) {
                return Ints.compare((int)o1.getPriority(), (int)o2.getPriority());
            }
        });
        return itemsList;
    }

    public static Set<IUnstructuredItem> getUnstructuredItems(Set<IProcessingItem> items) {
        HashSet unstructuredItems = Sets.newHashSet();
        for (IProcessingItem item : items) {
            if (!item.getProcessingItemType().equals((Object)ProcessingItemType.Unstructured)) continue;
            unstructuredItems.add((IUnstructuredItem)item);
        }
        return unstructuredItems;
    }
}

