/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.rm.jpo.scheduling.util.collection.BaseTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import gnu.trove.map.hash.TObjectFloatHashMap;

public class MutablePrimitivesTroveMap<K>
extends BaseTroveMap<K>
implements MutablePrimitivesMap<K> {
    MutablePrimitivesTroveMap(TObjectFloatHashMap troveMap) {
        super(troveMap);
    }

    @Override
    public void subtract(PositivePrimitivesMap<K> minuend) {
        for (K key : minuend.keySet()) {
            float oldValue;
            float newValue;
            if (!this.troveMap.contains(key) || !((double)(newValue = (oldValue = this.troveMap.remove(key)) - minuend.get(key)) > 0.0)) continue;
            this.troveMap.put(key, newValue);
        }
    }

    @Override
    public void add(PositivePrimitivesMap<K> summand) {
        for (K key : summand.keySet()) {
            float value = summand.get(key);
            this.troveMap.adjustOrPutValue(key, value, value);
        }
    }

    @Override
    public void put(K key, float value) {
        this.troveMap.put(key, value);
    }

    @Override
    public void add(K key, float value) {
        this.troveMap.adjustOrPutValue(key, value, value);
    }

    public static <K> MutablePrimitivesTroveMap<K> create() {
        return new MutablePrimitivesTroveMap<K>(new TObjectFloatHashMap(10, 0.75f, -2.1474836E9f));
    }

    public static <K> MutablePrimitivesMap<K> create(int size) {
        return new MutablePrimitivesTroveMap<K>(new TObjectFloatHashMap(size, 0.75f, -2.1474836E9f));
    }
}

