/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.DatePart;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.WindowOver;
import com.mysema.query.sql.WithinGroup;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.mysema.query.types.expr.Wildcard;
import java.util.EnumMap;
import java.util.Map;

public final class SQLExpressions {
    private static final Map<DatePart, Operator> DATE_ADD_OPS = new EnumMap<DatePart, Operator>(DatePart.class);
    private static final Map<DatePart, Operator> DATE_DIFF_OPS = new EnumMap<DatePart, Operator>(DatePart.class);
    private static final Map<DatePart, Operator> DATE_TRUNC_OPS = new EnumMap<DatePart, Operator>(DatePart.class);
    private static final WindowOver<Double> cumeDist;
    private static final WindowOver<Long> rank;
    private static final WindowOver<Long> denseRank;
    private static final WindowOver<Double> percentRank;
    private static final WindowOver<Long> rowNumber;
    public static final Expression<Object[]> all;
    public static final Expression<Long> countAll;

    private static Expression[] convertToExpressions(Object ... args) {
        Expression[] exprs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            exprs[i] = args[i] instanceof Expression ? (Expression)args[i] : new ConstantImpl<Object>(args[i]);
        }
        return exprs;
    }

    public static BooleanExpression any(BooleanExpression expr) {
        return BooleanOperation.create(Ops.AggOps.BOOLEAN_ANY, expr);
    }

    public static BooleanExpression all(BooleanExpression expr) {
        return BooleanOperation.create(Ops.AggOps.BOOLEAN_ALL, expr);
    }

    public static SimpleExpression<Long> nextval(String sequence) {
        return SQLExpressions.nextval(Long.class, sequence);
    }

    public static <T extends Number> SimpleExpression<T> nextval(Class<T> type, String sequence) {
        return SimpleOperation.create(type, SQLOps.NEXTVAL, ConstantImpl.create(sequence));
    }

    public static <D extends Comparable> DateExpression<D> date(DateTimeExpression<D> dateTime) {
        return DateOperation.create(dateTime.getType(), Ops.DateTimeOps.DATE, dateTime);
    }

    public static <D extends Comparable> DateExpression<D> date(Class<D> type, DateTimeExpression<?> dateTime) {
        return DateOperation.create(type, Ops.DateTimeOps.DATE, dateTime);
    }

    public static <D extends Comparable> DateTimeExpression<D> dateadd(DatePart unit, DateTimeExpression<D> date, int amount) {
        return DateTimeOperation.create(date.getType(), DATE_ADD_OPS.get((Object)unit), date, ConstantImpl.create(amount));
    }

    public static <D extends Comparable> DateExpression<D> dateadd(DatePart unit, DateExpression<D> date, int amount) {
        return DateOperation.create(date.getType(), DATE_ADD_OPS.get((Object)unit), date, ConstantImpl.create(amount));
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateExpression<D> start, DateExpression<D> end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), start, end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, D start, DateExpression<D> end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), ConstantImpl.create(start), end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateExpression<D> start, D end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), start, ConstantImpl.create(end));
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateTimeExpression<D> start, DateTimeExpression<D> end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), start, end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, D start, DateTimeExpression<D> end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), ConstantImpl.create(start), end);
    }

    public static <D extends Comparable> NumberExpression<Integer> datediff(DatePart unit, DateTimeExpression<D> start, D end) {
        return NumberOperation.create(Integer.class, DATE_DIFF_OPS.get((Object)unit), start, ConstantImpl.create(end));
    }

    public static <D extends Comparable> DateExpression<D> datetrunc(DatePart unit, DateExpression<D> expr) {
        return DateOperation.create(expr.getType(), DATE_TRUNC_OPS.get((Object)unit), expr);
    }

    public static <D extends Comparable> DateTimeExpression<D> datetrunc(DatePart unit, DateTimeExpression<D> expr) {
        return DateTimeOperation.create(expr.getType(), DATE_TRUNC_OPS.get((Object)unit), expr);
    }

    public static <D extends Comparable> DateTimeExpression<D> addYears(DateTimeExpression<D> date, int years) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_YEARS, date, ConstantImpl.create(years));
    }

    public static <D extends Comparable> DateTimeExpression<D> addMonths(DateTimeExpression<D> date, int months) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_MONTHS, date, ConstantImpl.create(months));
    }

    public static <D extends Comparable> DateTimeExpression<D> addWeeks(DateTimeExpression<D> date, int weeks) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_WEEKS, date, ConstantImpl.create(weeks));
    }

    public static <D extends Comparable> DateTimeExpression<D> addDays(DateTimeExpression<D> date, int days) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_DAYS, date, ConstantImpl.create(days));
    }

    public static <D extends Comparable> DateTimeExpression<D> addHours(DateTimeExpression<D> date, int hours) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_HOURS, date, ConstantImpl.create(hours));
    }

    public static <D extends Comparable> DateTimeExpression<D> addMinutes(DateTimeExpression<D> date, int minutes) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_MINUTES, date, ConstantImpl.create(minutes));
    }

    public static <D extends Comparable> DateTimeExpression<D> addSeconds(DateTimeExpression<D> date, int seconds) {
        return DateTimeOperation.create(date.getType(), Ops.DateTimeOps.ADD_SECONDS, date, ConstantImpl.create(seconds));
    }

    public static <D extends Comparable> DateExpression<D> addYears(DateExpression<D> date, int years) {
        return DateOperation.create(date.getType(), Ops.DateTimeOps.ADD_YEARS, date, ConstantImpl.create(years));
    }

    public static <D extends Comparable> DateExpression<D> addMonths(DateExpression<D> date, int months) {
        return DateOperation.create(date.getType(), Ops.DateTimeOps.ADD_MONTHS, date, ConstantImpl.create(months));
    }

    public static <D extends Comparable> DateExpression<D> addWeeks(DateExpression<D> date, int weeks) {
        return DateOperation.create(date.getType(), Ops.DateTimeOps.ADD_WEEKS, date, ConstantImpl.create(weeks));
    }

    public static <D extends Comparable> DateExpression<D> addDays(DateExpression<D> date, int days) {
        return DateOperation.create(date.getType(), Ops.DateTimeOps.ADD_DAYS, date, ConstantImpl.create(days));
    }

    public static <T extends Number> WindowOver<T> sum(Expression<T> expr) {
        return new WindowOver<Number>((Class<Number>)expr.getType(), Ops.AggOps.SUM_AGG, (Expression<?>)expr);
    }

    public static WindowOver<Long> count() {
        return new WindowOver<Long>(Long.class, Ops.AggOps.COUNT_ALL_AGG);
    }

    public static WindowOver<Long> count(Expression<?> expr) {
        return new WindowOver<Long>(Long.class, Ops.AggOps.COUNT_AGG, expr);
    }

    public static WindowOver<Long> countDistinct(Expression<?> expr) {
        return new WindowOver<Long>(Long.class, Ops.AggOps.COUNT_DISTINCT_AGG, expr);
    }

    public static <T extends Number> WindowOver<T> avg(Expression<T> expr) {
        return new WindowOver<Number>((Class<Number>)expr.getType(), Ops.AggOps.AVG_AGG, (Expression<?>)expr);
    }

    public static <T extends Comparable> WindowOver<T> min(Expression<T> expr) {
        return new WindowOver<Comparable>((Class<Comparable>)expr.getType(), Ops.AggOps.MIN_AGG, (Expression<?>)expr);
    }

    public static <T extends Comparable> WindowOver<T> max(Expression<T> expr) {
        return new WindowOver<Comparable>((Class<Comparable>)expr.getType(), Ops.AggOps.MAX_AGG, (Expression<?>)expr);
    }

    public static <T> WindowOver<T> lead(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.LEAD, (Expression<?>)expr);
    }

    public static <T> WindowOver<T> lag(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.LAG, (Expression<?>)expr);
    }

    public static WithinGroup<Object> listagg(Expression<?> expr, String delimiter) {
        return new WithinGroup<Object>(Object.class, SQLOps.LISTAGG, expr, (Expression<?>)ConstantImpl.create(delimiter));
    }

    public static <T> WindowOver<T> nthValue(Expression<T> measureExpr, Number n) {
        return SQLExpressions.nthValue(measureExpr, new ConstantImpl<Number>(n));
    }

    public static <T> WindowOver<T> nthValue(Expression<T> measureExpr, Expression<? extends Number> n) {
        return new WindowOver<Object>((Class<Object>)measureExpr.getType(), SQLOps.NTHVALUE, (Expression<?>)measureExpr, (Expression<?>)n);
    }

    public static <T extends Number> WindowOver<T> ntile(T num) {
        return new WindowOver<Object>((Class<Object>)num.getClass(), SQLOps.NTILE, (Expression<?>)new ConstantImpl<T>(num));
    }

    public static WindowOver<Long> rank() {
        return rank;
    }

    public static WithinGroup<Long> rank(Object ... args) {
        return SQLExpressions.rank(SQLExpressions.convertToExpressions(args));
    }

    public static WithinGroup<Long> rank(Expression<?> ... args) {
        return new WithinGroup<Long>(Long.class, SQLOps.RANK2, args);
    }

    public static WindowOver<Long> denseRank() {
        return denseRank;
    }

    public static WithinGroup<Long> denseRank(Object ... args) {
        return SQLExpressions.denseRank(SQLExpressions.convertToExpressions(args));
    }

    public static WithinGroup<Long> denseRank(Expression<?> ... args) {
        return new WithinGroup<Long>(Long.class, SQLOps.DENSERANK2, args);
    }

    public static WindowOver<Double> percentRank() {
        return percentRank;
    }

    public static WithinGroup<Double> percentRank(Object ... args) {
        return SQLExpressions.percentRank(SQLExpressions.convertToExpressions(args));
    }

    public static WithinGroup<Double> percentRank(Expression<?> ... args) {
        return new WithinGroup<Double>(Double.class, SQLOps.PERCENTRANK2, args);
    }

    public static <T extends Number> WithinGroup<T> percentileCont(T arg) {
        if (arg.doubleValue() < 0.0 || arg.doubleValue() > 1.0) {
            throw new IllegalArgumentException("The percentile value should be a number between 0 and 1");
        }
        return SQLExpressions.percentileCont(new ConstantImpl<T>(arg));
    }

    public static <T extends Number> WithinGroup<T> percentileCont(Expression<T> arg) {
        return new WithinGroup<Object>((Class<Object>)arg.getType(), SQLOps.PERCENTILECONT, (Expression<?>)arg);
    }

    public static <T extends Number> WithinGroup<T> percentileDisc(T arg) {
        if (arg.doubleValue() < 0.0 || arg.doubleValue() > 1.0) {
            throw new IllegalArgumentException("The percentile value should be a number between 0 and 1");
        }
        return SQLExpressions.percentileDisc(new ConstantImpl<T>(arg));
    }

    public static <T extends Number> WithinGroup<T> percentileDisc(Expression<T> arg) {
        return new WithinGroup<Object>((Class<Object>)arg.getType(), SQLOps.PERCENTILEDISC, (Expression<?>)arg);
    }

    public static WindowOver<Double> regrSlope(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_SLOPE, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrIntercept(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_INTERCEPT, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrCount(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_COUNT, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrR2(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_R2, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrAvgx(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_AVGX, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrAvgy(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_AVGY, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrSxx(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_SXX, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrSyy(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_SYY, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> regrSxy(Expression<? extends Number> arg1, Expression<? extends Number> arg2) {
        return new WindowOver<Object>((Class<Object>)Double.class, SQLOps.REGR_SXY, (Expression<?>)arg1, (Expression<?>)arg2);
    }

    public static WindowOver<Double> cumeDist() {
        return cumeDist;
    }

    public static WithinGroup<Double> cumeDist(Object ... args) {
        return SQLExpressions.cumeDist(SQLExpressions.convertToExpressions(args));
    }

    public static WithinGroup<Double> cumeDist(Expression<?> ... args) {
        return new WithinGroup<Double>(Double.class, SQLOps.CUMEDIST2, args);
    }

    public static WindowOver<Double> corr(Expression<? extends Number> expr1, Expression<? extends Number> expr2) {
        return new WindowOver<Double>(Double.class, SQLOps.CORR, (Expression<?>)expr1, (Expression<?>)expr2);
    }

    public static WindowOver<Double> covarPop(Expression<? extends Number> expr1, Expression<? extends Number> expr2) {
        return new WindowOver<Double>(Double.class, SQLOps.COVARPOP, (Expression<?>)expr1, (Expression<?>)expr2);
    }

    public static WindowOver<Double> covarSamp(Expression<? extends Number> expr1, Expression<? extends Number> expr2) {
        return new WindowOver<Double>(Double.class, SQLOps.COVARSAMP, (Expression<?>)expr1, (Expression<?>)expr2);
    }

    public static <T> WindowOver<T> ratioToReport(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.RATIOTOREPORT, (Expression<?>)expr);
    }

    public static WindowOver<Long> rowNumber() {
        return rowNumber;
    }

    public static <T extends Number> WindowOver<T> stddev(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.STDDEV, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> stddevDistinct(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.STDDEV_DISTINCT, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> stddevPop(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.STDDEVPOP, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> stddevSamp(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.STDDEVSAMP, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> variance(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.VARIANCE, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> varPop(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.VARPOP, (Expression<?>)expr);
    }

    public static <T extends Number> WindowOver<T> varSamp(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.VARSAMP, (Expression<?>)expr);
    }

    public static <T> WindowOver<T> firstValue(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.FIRSTVALUE, (Expression<?>)expr);
    }

    public static <T> WindowOver<T> lastValue(Expression<T> expr) {
        return new WindowOver<Object>((Class<Object>)expr.getType(), SQLOps.LASTVALUE, (Expression<?>)expr);
    }

    public static StringExpression left(Expression<String> lhs, int rhs) {
        return SQLExpressions.left(lhs, ConstantImpl.create(rhs));
    }

    public static StringExpression right(Expression<String> lhs, int rhs) {
        return SQLExpressions.right(lhs, ConstantImpl.create(rhs));
    }

    public static StringExpression left(Expression<String> lhs, Expression<Integer> rhs) {
        return StringOperation.create(Ops.StringOps.LEFT, lhs, rhs);
    }

    public static StringExpression right(Expression<String> lhs, Expression<Integer> rhs) {
        return StringOperation.create(Ops.StringOps.RIGHT, lhs, rhs);
    }

    private SQLExpressions() {
    }

    static {
        DATE_ADD_OPS.put(DatePart.year, Ops.DateTimeOps.ADD_YEARS);
        DATE_ADD_OPS.put(DatePart.month, Ops.DateTimeOps.ADD_MONTHS);
        DATE_ADD_OPS.put(DatePart.week, Ops.DateTimeOps.ADD_WEEKS);
        DATE_ADD_OPS.put(DatePart.day, Ops.DateTimeOps.ADD_DAYS);
        DATE_ADD_OPS.put(DatePart.hour, Ops.DateTimeOps.ADD_HOURS);
        DATE_ADD_OPS.put(DatePart.minute, Ops.DateTimeOps.ADD_MINUTES);
        DATE_ADD_OPS.put(DatePart.second, Ops.DateTimeOps.ADD_SECONDS);
        DATE_ADD_OPS.put(DatePart.millisecond, null);
        DATE_DIFF_OPS.put(DatePart.year, Ops.DateTimeOps.DIFF_YEARS);
        DATE_DIFF_OPS.put(DatePart.month, Ops.DateTimeOps.DIFF_MONTHS);
        DATE_DIFF_OPS.put(DatePart.week, Ops.DateTimeOps.DIFF_WEEKS);
        DATE_DIFF_OPS.put(DatePart.day, Ops.DateTimeOps.DIFF_DAYS);
        DATE_DIFF_OPS.put(DatePart.hour, Ops.DateTimeOps.DIFF_HOURS);
        DATE_DIFF_OPS.put(DatePart.minute, Ops.DateTimeOps.DIFF_MINUTES);
        DATE_DIFF_OPS.put(DatePart.second, Ops.DateTimeOps.DIFF_SECONDS);
        DATE_DIFF_OPS.put(DatePart.millisecond, null);
        DATE_TRUNC_OPS.put(DatePart.year, Ops.DateTimeOps.TRUNC_YEAR);
        DATE_TRUNC_OPS.put(DatePart.month, Ops.DateTimeOps.TRUNC_MONTH);
        DATE_TRUNC_OPS.put(DatePart.week, Ops.DateTimeOps.TRUNC_WEEK);
        DATE_TRUNC_OPS.put(DatePart.day, Ops.DateTimeOps.TRUNC_DAY);
        DATE_TRUNC_OPS.put(DatePart.hour, Ops.DateTimeOps.TRUNC_HOUR);
        DATE_TRUNC_OPS.put(DatePart.minute, Ops.DateTimeOps.TRUNC_MINUTE);
        DATE_TRUNC_OPS.put(DatePart.second, Ops.DateTimeOps.TRUNC_SECOND);
        cumeDist = new WindowOver<Double>(Double.class, SQLOps.CUMEDIST);
        rank = new WindowOver<Long>(Long.class, SQLOps.RANK);
        denseRank = new WindowOver<Long>(Long.class, SQLOps.DENSERANK);
        percentRank = new WindowOver<Double>(Double.class, SQLOps.PERCENTRANK);
        rowNumber = new WindowOver<Long>(Long.class, SQLOps.ROWNUMBER);
        all = Wildcard.all;
        countAll = Wildcard.count;
    }
}

