/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.mysema.query.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;

public class GeometryWktType
extends AbstractType<Geometry> {
    public static final GeometryWktType DEFAULT = new GeometryWktType();

    public GeometryWktType() {
        super(12);
    }

    @Override
    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Override
    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        String str = rs.getString(startIndex);
        if (str != null) {
            return Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).decode(str);
        }
        return null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(value);
        st.setString(startIndex, str);
    }

    @Override
    public String getLiteral(Geometry geometry) {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry);
        return "'" + str + "'";
    }
}

