/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Constant;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;

public final class HashCodeVisitor
implements Visitor<Integer, Void> {
    public static final HashCodeVisitor DEFAULT = new HashCodeVisitor();

    private HashCodeVisitor() {
    }

    @Override
    public Integer visit(Constant<?> expr, Void context) {
        return expr.getConstant().hashCode();
    }

    @Override
    public Integer visit(FactoryExpression<?> expr, Void context) {
        int result = expr.getType().hashCode();
        return 31 * result + expr.getArgs().hashCode();
    }

    @Override
    public Integer visit(Operation<?> expr, Void context) {
        int result = expr.getOperator().hashCode();
        return 31 * result + expr.getArgs().hashCode();
    }

    @Override
    public Integer visit(ParamExpression<?> expr, Void context) {
        return expr.getName().hashCode();
    }

    @Override
    public Integer visit(Path<?> expr, Void context) {
        return expr.getMetadata().hashCode();
    }

    @Override
    public Integer visit(SubQueryExpression<?> expr, Void context) {
        return expr.getMetadata().hashCode();
    }

    @Override
    public Integer visit(TemplateExpression<?> expr, Void context) {
        int result = expr.getTemplate().hashCode();
        return 31 * result + expr.getArgs().hashCode();
    }
}

