/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.websections;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.rm.common.bridges.api.plugins.PluginNotAvailableException;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.module.propertyset.PropertySet;
import com.radiantminds.plugins.jira.utils.RecentPlans;
import com.radiantminds.plugins.jira.utils.RecentlyVisited;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.jpo2.api.Portfolio2Exception;
import com.radiantminds.roadmap.jpo2.api.plans.Plan;
import com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridge;
import com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridgeProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitedItemsLinkFactory
implements SimpleLinkFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitedItemsLinkFactory.class);
    private final UserPropertyManager userPropertyManager;
    private final PortfolioPlanPersistence planPersistence;
    private final ApplicationProperties applicationProperties;
    private final UserExtension userExtension;
    private final PlanListingServiceBridgeProxy planListingServiceBridgeProxy;

    public VisitedItemsLinkFactory(UserPropertyManager userPropertyManager, ApplicationProperties applicationProperties, PortfolioPlanPersistence planPersistence, UserExtension userExtension, PlanListingServiceBridgeProxy planListingServiceBridgeProxy) {
        this.applicationProperties = applicationProperties;
        this.userPropertyManager = userPropertyManager;
        this.planPersistence = planPersistence;
        this.userExtension = userExtension;
        this.planListingServiceBridgeProxy = planListingServiceBridgeProxy;
    }

    public void init(SimpleLinkFactoryModuleDescriptor simpleLinkFactoryModuleDescriptor) {
    }

    @Nonnull
    public List<SimpleLink> getLinks(User user, Map<String, Object> stringObjectMap) {
        StopWatch overallTimer = new StopWatch();
        overallTimer.start();
        PropertySet propertySet = this.getUserPropertySet(user);
        String baseUrl = this.applicationProperties.getBaseUrl();
        ArrayList retVal = Lists.newArrayList();
        try {
            List<RecentlyVisited> recentPlans = this.getRecentlyVisitedPlans(propertySet);
            Map<Long, Plan> portfolio2Plans = this.getPorfolio2PlansOrEmptyMap(recentPlans);
            Map<Long, Plan> portfolio3Plans = this.getPorfolio3PlansOrEmptyMap(recentPlans);
            Map<Long, String> programTitles = this.getProgramTitles(recentPlans);
            for (RecentlyVisited recentlyVisited : recentPlans) {
                Long programId;
                String programTitle;
                Plan plan;
                if (recentlyVisited.getEntityType().equals((Object)RecentlyVisited.EntityType.LIVE_PLAN)) {
                    plan = portfolio2Plans.get(recentlyVisited.getId());
                    if (plan == null) continue;
                    retVal.add(VisitedItemsLinkFactory.createPortfolio2Link(plan, recentlyVisited.getScenarioId(), baseUrl));
                    continue;
                }
                if (recentlyVisited.getEntityType().equals((Object)RecentlyVisited.EntityType.SIMPLE_PLAN)) {
                    plan = portfolio3Plans.get(recentlyVisited.getId());
                    if (plan == null) continue;
                    retVal.add(VisitedItemsLinkFactory.createPortfolio3Link(plan, recentlyVisited.getScenarioId(), baseUrl));
                    continue;
                }
                if (!recentlyVisited.getEntityType().equals((Object)RecentlyVisited.EntityType.PROGRAM) || (programTitle = programTitles.get(programId = recentlyVisited.getId())) == null) continue;
                retVal.add(VisitedItemsLinkFactory.createProgramLink(programId, programTitle, baseUrl));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create plan dropdown links.", (Throwable)e);
        }
        overallTimer.stop();
        LOGGER.debug("overall time for getLinks method: {}ms", (Object)overallTimer.getTime());
        return retVal;
    }

    private Map<Long, String> getProgramTitles(List<RecentlyVisited> recentPlans) {
        try {
            PlanListingServiceBridge planListingServiceBridge = (PlanListingServiceBridge)this.planListingServiceBridgeProxy.get();
            HashSet programIds = Sets.newHashSet();
            for (RecentlyVisited visited : recentPlans) {
                if (visited.getEntityType() == null || !visited.getEntityType().equals((Object)RecentlyVisited.EntityType.PROGRAM)) continue;
                programIds.add(visited.getId());
            }
            return planListingServiceBridge.getProgramTitle(programIds);
        }
        catch (Exception e) {
            LOGGER.error("Error trying to retrieve program titles! Failing silently!", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<Long, Plan> getPorfolio2PlansOrEmptyMap(List<RecentlyVisited> recentPlans) {
        Map<Long, Plan> portfolio2Plans;
        try {
            portfolio2Plans = this.getPortfolio2Plans(recentPlans);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve live plans.", (Throwable)e);
            portfolio2Plans = Collections.emptyMap();
        }
        return portfolio2Plans;
    }

    private Map<Long, Plan> getPorfolio3PlansOrEmptyMap(List<RecentlyVisited> recentPlans) {
        Map<Long, Plan> portfolio3Plans;
        try {
            portfolio3Plans = this.getPortfolio3Plans(recentPlans);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to retrieve simple plans.", (Throwable)e);
            portfolio3Plans = Collections.emptyMap();
        }
        return portfolio3Plans;
    }

    private List<RecentlyVisited> getRecentlyVisitedPlans(PropertySet propertySet) {
        return propertySet != null ? RecentPlans.getPlans(this.planPersistence, propertySet) : Lists.newArrayList();
    }

    private PropertySet getUserPropertySet(User user) {
        return user != null ? this.userPropertyManager.getPropertySet(ApplicationUsers.from((User)user)) : null;
    }

    @Nonnull
    public List<SimpleLink> getLinks(ApplicationUser user, Map<String, Object> stringObjectMap) {
        return this.getLinks(ApplicationUsers.toDirectoryUser((ApplicationUser)user), stringObjectMap);
    }

    private Map<Long, IPlan> retrieveVisiblePortfolio1Plans() throws Exception {
        StopWatch listPlansTimer = new StopWatch();
        listPlansTimer.start();
        Map<String, IPlan> plansWithPermission = this.planPersistence.listPlansWithPermission(this.userExtension.getActiveUserData());
        listPlansTimer.stop();
        HashMap plansById = Maps.newHashMap();
        LOGGER.debug("List plans with custom query: {}ms", (Object)listPlansTimer.getTime());
        for (String strKey : plansWithPermission.keySet()) {
            plansById.put(Long.parseLong(strKey), plansWithPermission.get(strKey));
        }
        return plansById;
    }

    private static SimpleLinkImpl createPortfolio2Link(Plan plan, Optional<Long> scenarioId, String baseUrl) {
        String url = scenarioId.isPresent() ? String.format("%s/secure/PortfolioPlanView.jspa?id=%s&sid=%d#backlog", baseUrl, plan.getId(), scenarioId.get()) : String.format("%s/secure/PortfolioPlanView.jspa?id=%s#backlog", baseUrl, plan.getId());
        return new SimpleLinkImpl(String.format("plugins-jira-webitem-plan-%s", plan.getId()), (String)plan.getTitle().or((Object)"Untitled plan"), null, null, null, url, null);
    }

    private static SimpleLinkImpl createPortfolio3Link(Plan plan, Optional<Long> scenarioId, String baseUrl) {
        String url = scenarioId.isPresent() ? String.format("%s/secure/ManualPlans.jspa?id=%s&sid=%d#backlog", baseUrl, plan.getId(), scenarioId.get()) : String.format("%s/secure/ManualPlans.jspa?id=%s#backlog", baseUrl, plan.getId());
        return new SimpleLinkImpl(String.format("plugins-jira-webitem-plan-%s", plan.getId()), (String)plan.getTitle().or((Object)"Untitled plan"), null, null, null, url, null);
    }

    private static SimpleLinkImpl createProgramLink(Long programId, String programTitle, String baseUrl) {
        String url = String.format("%s/secure/PortfolioProgramView.jspa?id=%d", baseUrl, programId);
        return new SimpleLinkImpl(String.format("plugins-jira-webitem-program-%s", programId), programTitle, null, null, null, url, null);
    }

    private Map<Long, Plan> getPortfolio2Plans(List<RecentlyVisited> recentPlans) {
        Iterable<RecentlyVisited> jpo2PlanIdStrings = this.filterJPO2Plans(recentPlans);
        Iterable<Long> jpoPlanIds = this.getPlanIds(jpo2PlanIdStrings);
        if (!Iterables.isEmpty(jpoPlanIds)) {
            try {
                return this.getMapOfPlansById(jpoPlanIds);
            }
            catch (PluginNotAvailableException | Portfolio2Exception e) {
                LOGGER.warn("Unable to retrieve live plans.", (Throwable)e);
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    private Map<Long, Plan> getPortfolio3Plans(List<RecentlyVisited> recentPlans) {
        Iterable<RecentlyVisited> jpo3PlanIdStrings = this.filterJPO3Plans(recentPlans);
        Iterable<Long> jpoPlanIds = this.getPlanIds(jpo3PlanIdStrings);
        if (!Iterables.isEmpty(jpoPlanIds)) {
            try {
                return this.getMapOfPlansById(jpoPlanIds);
            }
            catch (PluginNotAvailableException | Portfolio2Exception e) {
                LOGGER.warn("Unable to retrieve manual plans.", (Throwable)e);
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    private Map<Long, Plan> getMapOfPlansById(Iterable<Long> jpoPlanIds) throws PluginNotAvailableException, Portfolio2Exception {
        PlanListingServiceBridge planListingServiceBridge = (PlanListingServiceBridge)this.planListingServiceBridgeProxy.get();
        List<Plan> plans = planListingServiceBridge.getPlans(Sets.newHashSet(jpoPlanIds));
        return Maps.newHashMap((Map)Maps.uniqueIndex(plans, (Function)new Function<Plan, Long>(){

            public Long apply(Plan plan) {
                return plan.getId();
            }
        }));
    }

    private Iterable<Long> getPlanIds(Iterable<RecentlyVisited> recentVisitedItems) {
        return Iterables.transform(recentVisitedItems, (Function)new Function<RecentlyVisited, Long>(){

            public Long apply(RecentlyVisited recentlyVisited) {
                return recentlyVisited.getId();
            }
        });
    }

    private Iterable<RecentlyVisited> filterJPO2Plans(List<RecentlyVisited> recentPlans) {
        return Iterables.filter(recentPlans, (Predicate)new Predicate<RecentlyVisited>(){

            public boolean apply(@Nullable RecentlyVisited input) {
                return input != null && input.getEntityType() != null && input.getEntityType().equals((Object)RecentlyVisited.EntityType.LIVE_PLAN);
            }
        });
    }

    private Iterable<RecentlyVisited> filterJPO3Plans(List<RecentlyVisited> recentPlans) {
        return Iterables.filter(recentPlans, (Predicate)new Predicate<RecentlyVisited>(){

            public boolean apply(@Nullable RecentlyVisited input) {
                return input != null && input.getEntityType() != null && input.getEntityType().equals((Object)RecentlyVisited.EntityType.SIMPLE_PLAN);
            }
        });
    }
}

