/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.IPlanGeneratorConfiguration;
import com.radiantminds.roadmap.common.data.generator.IPlanPersistency;
import com.radiantminds.roadmap.common.data.generator.backlog.BacklogPersistency;
import com.radiantminds.roadmap.common.data.generator.backlog.IBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.ISettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.SettingsPersistency;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.TeamsPersistency;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.generator.time.ITimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.TimePlanPersistency;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlan;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlanConfiguration;

public class PlanPersistency
implements IPlanPersistency {
    private static final Log LOGGER = Log.with(PlanPersistency.class);
    private final PortfolioPlanPersistence planPersistence;
    private final SettingsPersistency settingsPersistency;
    private final TeamsPersistency teamsPersistency;
    private final BacklogPersistency backlogPersistency;
    private final TimePlanPersistency timePlanPersistency;

    public PlanPersistency(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence persistency, PortfolioPersonPersistence personPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence, PortfolioAbilityPersistence abilityPersistence, PortfolioTeamPersistence teamPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioSprintPersistence sprintPersistence, PortfolioReleasePersistence releasePersistence, PortfolioStreamPersistence streamPersistence, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence, PortfolioPresenceIntervalPersistence presenceIntervalPersistence, PortfolioAbsenceIntervalPersistence absenceIntervalPersistence) {
        this.planPersistence = persistency;
        this.settingsPersistency = new SettingsPersistency(stagePersistence, skillPersistence);
        this.backlogPersistency = new BacklogPersistency(activeObjectsUtilities, workItemPersistence);
        this.teamsPersistency = new TeamsPersistency(personPersistence, abilityPersistence, teamPersistence, resourcePersistence, sprintPersistence, availabilityIntervalPersistence, presenceIntervalPersistence, absenceIntervalPersistence);
        this.timePlanPersistency = new TimePlanPersistency(streamPersistence, releasePersistence);
    }

    @Override
    public IPlan persistPlan(IPlanGeneratorConfiguration configuration, PlanTemplate template) throws Exception {
        Long start = System.currentTimeMillis();
        RestPlan plan = new RestPlan(null, null, null);
        plan.setInReplanning(false);
        plan.setInStreamMode(false);
        plan.setPlanVersion(1L);
        plan.setSchedulingVersion(1L);
        plan.setReplanningVersion(0L);
        plan.setTitle((String)configuration.getTitle().orNull());
        plan.setDetails((String)configuration.getDescription().orNull());
        plan.setDate((Long)configuration.getReplanningInstant().orNull());
        plan.setInStreamMode(configuration.isStreamMode());
        IPlan persistedPlan = this.planPersistence.persist(plan);
        Long now = System.currentTimeMillis();
        ISettingsConfiguration settingsConfiguration = configuration.getSettingsConfiguration();
        this.settingsPersistency.persistSettings(settingsConfiguration, persistedPlan);
        LOGGER.info("[persistPlan] Settings:\t" + (System.currentTimeMillis() - now) + "ms", new Object[0]);
        now = System.currentTimeMillis();
        ITeamsConfiguration teamsConfiguration = configuration.getTeamsConfiguration();
        this.teamsPersistency.persist(teamsConfiguration, persistedPlan);
        LOGGER.info("[persistPlan] Teams:\t" + (System.currentTimeMillis() - now) + "ms", new Object[0]);
        now = System.currentTimeMillis();
        ITimePlanConfiguration timePlanConfiguration = configuration.getTimePlanConfiguration();
        this.timePlanPersistency.persist(timePlanConfiguration, persistedPlan);
        LOGGER.info("[persistPlan] TimePlan:\t" + (System.currentTimeMillis() - now) + "ms", new Object[0]);
        now = System.currentTimeMillis();
        IBacklogConfiguration backlogConfiguration = configuration.getBacklogConfiguration();
        this.backlogPersistency.persistBacklog(backlogConfiguration, persistedPlan);
        LOGGER.info("[persistPlan] Backlog:\t" + (System.currentTimeMillis() - now) + "ms", new Object[0]);
        now = System.currentTimeMillis();
        RestPlanConfiguration config = this.createPlanConfiguration(settingsConfiguration, template);
        this.planPersistence.setPlanConfiguration(persistedPlan.getId(), config);
        LOGGER.info("[persistPlan] TOTAL:\t" + (System.currentTimeMillis() - start) + "ms", new Object[0]);
        return persistedPlan;
    }

    private RestPlanConfiguration createPlanConfiguration(ISettingsConfiguration configuration, PlanTemplate template) {
        RestPlanConfiguration planConfiguration = new RestPlanConfiguration(configuration.isSprintWarningsEnabled(), configuration.isSprintConstraintEnabled(), null, null, configuration.getMinimumWorkLoadForUnstructuredEpics(), configuration.getMaxAssignableResourcesPerStory(), configuration.getPlanningUnit(), null, null, null, null, template, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return planConfiguration;
    }
}

